/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IMergeOptions;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.dialogs.LocationInputDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeDialog
extends LocationInputDialog {
    private static final String TITLE = UITexts.MergeDialog_Title;
    private static final String MESSAGE = UITexts.MergeDialog_Message;
    private ArrayList<Option> options;
    private Button reprocess;
    private Button pull;
    private Button uncommitted;
    private MergeDialogInfo dialogInfo;

    public MergeDialog(Shell parentShell, Collection<IBzrBranch> locations, IBzrBranch initialBranch, MergeDialogInfo dialogInfo) {
        super(parentShell, TITLE, MESSAGE, initialBranch, new LocationInputDialog.BaseURIValidator(), locations, dialogInfo, true, false, true, false, false);
        this.setShellStyle(2160);
        this.setBlockOnOpen(true);
        this.dialogInfo = dialogInfo;
    }

    @Override
    protected void createOptionsArea(Composite composite) {
        Composite container = new Composite(composite, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1, 1, true, false));
        Group checkBoxGroup = new Group(container, 0);
        checkBoxGroup.setLayout((Layout)new GridLayout(2, true));
        super.createOptions((Composite)checkBoxGroup);
        this.reprocess = new Button((Composite)checkBoxGroup, 32);
        this.reprocess.setText(UITexts.MergeDialog_Reprocess);
        this.reprocess.setSelection(false);
        this.reprocess.setToolTipText(UITexts.MergeDialog_ReprocessTooltip);
        this.pull = new Button((Composite)checkBoxGroup, 32);
        this.pull.setText(UITexts.MergeDialog_Pull);
        this.pull.setSelection(false);
        this.uncommitted = new Button((Composite)checkBoxGroup, 32);
        this.uncommitted.setText(UITexts.MergeDialog_Uncommitted);
        this.uncommitted.setSelection(false);
        this.uncommitted.setToolTipText(UITexts.MergeDialog_UncommittedTooltip);
        Group revisionGroup = new Group(container, 0);
        revisionGroup.setLayout((Layout)new GridLayout());
        this.createRevisionSelector(revisionGroup, true);
        revisionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        checkBoxGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        container.setLayoutData((Object)new GridData(1808));
    }

    @Override
    protected void okPressed() {
        this.options = new ArrayList(0);
        if (this.isRemember().booleanValue()) {
            this.options.add(IMergeOptions.REMEMBER);
        }
        if (this.isForce().booleanValue()) {
            this.options.add(IMergeOptions.FORCE);
        }
        if (this.pull.getSelection()) {
            this.options.add(IMergeOptions.PULL);
        }
        if (this.reprocess.getSelection()) {
            this.options.add(IMergeOptions.REPROCESS);
        }
        if (this.uncommitted.getSelection()) {
            this.options.add(IMergeOptions.UNCOMMITTED);
        }
        if (this.isRevisionSelected()) {
            this.options.add((Option)IMergeOptions.REVISION.setArgument(this.getSelectedRevision()));
        }
        this.dialogInfo.options = this.options;
        super.okPressed();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 430);
        MergeDialog dialog = new MergeDialog(shell, Collections.EMPTY_LIST, null, new MergeDialogInfo());
        dialog.setBlockOnOpen(true);
        int exit = dialog.open();
        System.out.println("exit: " + exit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MergeDialogInfo
    extends LocationInputDialog.LocationDialogInfo {
        List<Option> options;

        public List<Option> getOptions() {
            return this.options;
        }
    }
}

