/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IRevertOptions;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.dialogs.ShowLogDialog;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionComposite;
import org.vcs.bazaar.eclipse.ui.widgets.RevisionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertDialog
extends Dialog {
    private Button forgetMerges;
    private Button noBackup;
    private Button wholeBranch;
    private RevisionNumber revision;
    private ArrayList<Option> options;
    private BzrResourceSelectionComposite resourcesComposite;
    private List<IBzrResourceStatus> selection;
    private boolean isWholeBranch;
    private boolean wholeBranchEnabled;

    public RevertDialog(Shell parentShell, List<IBzrResourceStatus> resources, List<IBzrResourceStatus> selectedResources) {
        super(parentShell);
        this.setShellStyle(2160);
        this.setBlockOnOpen(true);
        this.resourcesComposite = this.getBzrResourceSelectionComposite();
        this.resourcesComposite.setSelection(selectedResources);
        this.resourcesComposite.setResources(resources);
    }

    private BzrResourceSelectionComposite getBzrResourceSelectionComposite() {
        return new BzrResourceSelectionComposite(){

            protected String getUpperLabel() {
                return "Checked resources will be reverted:";
            }

            protected void createOption(Composite optionComposite) {
                if (RevertDialog.this.wholeBranchEnabled) {
                    RevertDialog.this.wholeBranch = new Button(optionComposite, 32);
                    RevertDialog.this.wholeBranch.setText("Revert the whole branch");
                }
                Group optionGroup = new Group(optionComposite, 0);
                optionGroup.setText(UITexts.Dialog_optionsGroup);
                optionGroup.setLayout((Layout)new GridLayout(2, false));
                RevertDialog.this.revision = new RevisionNumber((Composite)optionGroup);
                RevertDialog.this.revision.showLogButton(false);
                Composite checkboxContainer = new Composite((Composite)optionGroup, 0);
                checkboxContainer.setLayout((Layout)new GridLayout());
                RevertDialog.this.forgetMerges = new Button(checkboxContainer, 32);
                RevertDialog.this.forgetMerges.setText("Forget merges");
                RevertDialog.this.noBackup = new Button(checkboxContainer, 32);
                RevertDialog.this.noBackup.setText("No backup");
                GridData data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 2;
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = false;
                optionGroup.setLayoutData((Object)data);
                checkboxContainer.setLayoutData((Object)data);
                RevertDialog.this.revision.addShowLogButtonSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        RevertDialog.this.showLog();
                    }
                });
            }
        };
    }

    protected void showLog() {
        ShowLogDialog dialog;
        IBzrBranch branch = this.resourcesComposite.getResources().get(0).getResource().getBranch();
        if (branch != null && (dialog = new ShowLogDialog(this.getShell(), branch)).open() == 0 && dialog.getSelectedRevision() != null) {
            this.revision.setRevision(dialog.getSelectedRevision().getValue());
        }
    }

    public void create() {
        super.create();
        this.enableOkButton();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout());
        Composite control = this.resourcesComposite.createControls(container);
        control.setLayoutData((Object)new GridData(1808));
        this.resourcesComposite.refreshTableViewer();
        this.resourcesComposite.addUntrackedFilesFilter();
        this.resourcesComposite.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RevertDialog.this.enableOkButton();
            }
        });
        this.makeActions();
        return container;
    }

    private void makeActions() {
        if (this.wholeBranchEnabled) {
            this.wholeBranch.setSelection(false);
            this.wholeBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevertDialog.this.resourcesComposite.getTableViewer().getTable().setEnabled(!RevertDialog.this.wholeBranch.getSelection() && !RevertDialog.this.forgetMerges.getSelection());
                    RevertDialog.this.enableOkButton();
                }
            });
        }
        this.forgetMerges.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled;
                boolean bl = enabled = !RevertDialog.this.forgetMerges.getSelection();
                if (RevertDialog.this.wholeBranchEnabled) {
                    enabled &= !RevertDialog.this.wholeBranch.getSelection();
                }
                RevertDialog.this.resourcesComposite.getTableViewer().getTable().setEnabled(enabled);
                RevertDialog.this.enableOkButton();
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[this.options.size()]);
    }

    private void enableOkButton() {
        boolean enabled = !this.resourcesComposite.getSelection().isEmpty();
        enabled |= this.wholeBranchEnabled ? this.wholeBranch.getSelection() : false;
        this.getButton(0).setEnabled(enabled |= this.forgetMerges.getSelection());
    }

    protected void okPressed() {
        this.selection = this.resourcesComposite.getSelection();
        this.options = new ArrayList(0);
        if (this.forgetMerges.getSelection()) {
            this.options.add(IRevertOptions.FORGET_MERGES);
        }
        if (this.noBackup.getSelection()) {
            this.options.add(IRevertOptions.NO_BACKUP);
        }
        if (this.revision.isRevisionSelected()) {
            this.options.add((Option)IRevertOptions.REVISION.setArgument(this.revision.getRevision()));
        }
        this.isWholeBranch = this.wholeBranchEnabled ? this.wholeBranch.getSelection() : false;
        this.isWholeBranch |= this.forgetMerges.getSelection();
        super.okPressed();
    }

    public List<IBzrResourceStatus> getSelection() {
        return this.selection;
    }

    public boolean isWholeBranch() {
        return this.isWholeBranch;
    }

    public void setWholeBranchEnabled(boolean enable) {
        this.wholeBranchEnabled = enable;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        RevertDialog dialog = new RevertDialog(shell, new ArrayList<IBzrResourceStatus>(0), new ArrayList<IBzrResourceStatus>(0));
        dialog.setBlockOnOpen(true);
        int exit = dialog.open();
        System.out.println("exit: " + exit);
    }
}

