/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.ISendOptions;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.dialogs.LocationInputDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendDialog
extends LocationInputDialog {
    private static final String TITLE = UITexts.BazaarSendDialogTitle;
    private static final String MESSAGE = UITexts.BazaarSendDialogMessage;
    private ArrayList<Option> options;
    private Button nobundle;
    private Button nopatch;
    private Button send;
    private Button save;
    private SendDialogInfo dialogInfo;
    private Text submitLocationText;
    private Text messageText;
    private Text formatText;

    public SendDialog(Shell parentShell, Collection<IBzrBranch> locations, IBzrBranch initialBranch, SendDialogInfo dialogInfo) {
        super(parentShell, TITLE, MESSAGE, initialBranch, new LocationInputDialog.BaseURIValidator(), locations, dialogInfo, true, false, false, false, false);
        this.setShellStyle(2160);
        this.setBlockOnOpen(true);
        this.dialogInfo = dialogInfo;
    }

    @Override
    protected void createOptionsArea(Composite composite) {
        this.setTitle(TITLE);
        Group typeBoxGroup = new Group(composite, 0);
        typeBoxGroup.setText(UITexts.SendDialog_EnterLocation);
        typeBoxGroup.setLayout((Layout)new GridLayout());
        typeBoxGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite typeBoxRadioArea = new Composite((Composite)typeBoxGroup, 0);
        GridData typeBoxGrid = new GridData();
        typeBoxGrid.horizontalAlignment = 4;
        typeBoxRadioArea.setLayout((Layout)new GridLayout(2, true));
        typeBoxRadioArea.setLayoutData((Object)typeBoxGrid);
        this.send = new Button(typeBoxRadioArea, 16);
        this.send.setText(UITexts.SendDialog_SendEmail);
        this.send.setSelection(true);
        this.send.setToolTipText(UITexts.SendDialog_SendEmailTooltip);
        this.save = new Button(typeBoxRadioArea, 16);
        this.save.setText(UITexts.SendDialog_SaveLocation);
        this.save.setSelection(false);
        this.save.setToolTipText(UITexts.SendDialog_SaveLocationTooltip);
        Composite submitComosite = new Composite((Composite)typeBoxGroup, 0);
        submitComosite.setLayout((Layout)new GridLayout(2, false));
        GridData submitLocationGrid = new GridData();
        submitLocationGrid.horizontalAlignment = 4;
        submitLocationGrid.widthHint = 440;
        this.submitLocationText = new Text(submitComosite, 2052);
        this.submitLocationText.setLayoutData((Object)submitLocationGrid);
        this.submitLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SendDialog.this.send.getSelection()) {
                    SendDialog.this.validateInput();
                }
            }
        });
        GridData locationBoxGrid = new GridData();
        locationBoxGrid.horizontalAlignment = 4;
        submitComosite.setLayoutData((Object)locationBoxGrid);
        final Button browseButton = new Button(submitComosite, 8);
        browseButton.setText(UITexts.BazaarSendDialogBrowse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SendDialog.this.getShell(), 8192);
                dialog.setText("Save As");
                String dir = dialog.open();
                if (dir != null) {
                    SendDialog.this.submitLocationText.setText(dir);
                }
            }
        });
        browseButton.setEnabled(false);
        this.save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browseButton.setEnabled(true);
                SendDialog.this.validateInput();
                super.widgetSelected(e);
            }
        });
        this.send.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browseButton.setEnabled(false);
                SendDialog.this.validateInput();
                super.widgetSelected(e);
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText("Message");
        GridData messageGrid = new GridData();
        messageGrid.horizontalAlignment = 4;
        this.messageText = new Text(composite, 2052);
        this.messageText.setLayoutData((Object)messageGrid);
        Composite container = new Composite(composite, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1, 1, true, false));
        Group checkBoxGroup = new Group(container, 0);
        checkBoxGroup.setLayout((Layout)new GridLayout(2, false));
        super.createOptions((Composite)checkBoxGroup);
        this.nobundle = new Button((Composite)checkBoxGroup, 32);
        this.nobundle.setText(UITexts.SendDialog_NoBundle);
        this.nobundle.setSelection(false);
        this.nobundle.setToolTipText(UITexts.SendDialog_NoBundleTooltip);
        this.nopatch = new Button((Composite)checkBoxGroup, 32);
        this.nopatch.setText(UITexts.SendDialog_NoPatch);
        this.nopatch.setSelection(false);
        this.nopatch.setToolTipText(UITexts.SendDialog_NoPatchTooltip);
        Composite formatBoxGroup = new Composite((Composite)checkBoxGroup, 0);
        GridData formatBoxGrid = new GridData();
        formatBoxGrid.horizontalAlignment = 4;
        formatBoxGroup.setLayout((Layout)new GridLayout(2, false));
        formatBoxGroup.setLayoutData((Object)formatBoxGrid);
        Label label3 = new Label(formatBoxGroup, 0);
        label3.setText(UITexts.SendDialog_Format);
        this.formatText = new Text(formatBoxGroup, 2052);
        Group revisionGroup = new Group(container, 0);
        revisionGroup.setLayout((Layout)new GridLayout());
        this.createRevisionSelector(revisionGroup, false);
        revisionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        checkBoxGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        container.setLayoutData((Object)new GridData(1808));
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        Pattern p;
        Matcher m;
        boolean matchFound;
        if (errorMessage == null && this.send != null && !this.send.isDisposed() && this.send.getSelection() && !(matchFound = (m = (p = Pattern.compile(".+@.+\\.[a-z]+")).matcher(this.getPath())).matches())) {
            errorMessage = UITexts.SendDialog_WrongEmail;
        }
        super.setErrorMessage(errorMessage);
    }

    public String getPath() {
        return this.submitLocationText.getText();
    }

    public String getMessage() {
        return this.messageText.getText();
    }

    public String getFormat() {
        return this.formatText.getText();
    }

    public Integer getType() {
        if (this.send.getSelection()) {
            return 0;
        }
        return 1;
    }

    protected Boolean isNoBundle() {
        return this.nobundle.getSelection();
    }

    protected Boolean isNoPatch() {
        return this.nopatch.getSelection();
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[this.options.size()]);
    }

    @Override
    protected void okPressed() {
        this.options = new ArrayList(0);
        if (this.getPath().length() > 0 && this.getValue().length() > 0) {
            if (this.getType() == 0) {
                this.options.add((Option)ISendOptions.MAIL_TO.setArgument(this.getPath()));
            } else {
                this.options.add((Option)ISendOptions.OUTPUT.setArgument(this.getPath()));
            }
        } else {
            return;
        }
        this.options.add((Option)ISendOptions.MESSAGE.setArgument(this.getMessage()));
        if (this.isRemember().booleanValue()) {
            this.options.add(ISendOptions.REMEMBER);
        }
        if (this.isNoBundle().booleanValue()) {
            this.options.add(ISendOptions.NO_BUNDLE);
        }
        if (this.isNoPatch().booleanValue()) {
            this.options.add(ISendOptions.NO_PATCH);
        }
        if (this.isRevisionSelected()) {
            this.options.add((Option)ISendOptions.REVISION.setArgument(this.getSelectedRevision()));
        }
        if (this.getFormat().length() > 0) {
            this.options.add((Option)ISendOptions.FORMAT.setArgument(this.getFormat()));
        }
        this.dialogInfo.options = this.options;
        super.okPressed();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        SendDialog dialog = new SendDialog(shell, Collections.EMPTY_LIST, null, new SendDialogInfo());
        dialog.setBlockOnOpen(true);
        int exit = dialog.open();
        System.out.println("exit: " + exit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SendDialogInfo
    extends LocationInputDialog.LocationDialogInfo {
        List<Option> options;

        public List<Option> getOptions() {
            return this.options;
        }
    }
}

