/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShelveDialog
extends Dialog {
    private BzrResourceSelectionComposite resourcesComposite;
    private Button wholeBranch;
    private Text messageTextBox;
    private Label messageTextLabel;
    private boolean wholeBranchEnabled = true;
    private List<IBzrResourceStatus> shelveableResources;
    private List<IBzrResourceStatus> selectedResources;
    private List<IBzrResourceStatus> selectedFiles;
    private String message;
    private boolean isWholeBranch;

    public ShelveDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
        this.setBlockOnOpen(true);
    }

    public void create() {
        super.create();
        this.enableOkButton();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UITexts.ShelveDialog_title);
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite messageArea = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().applyTo(messageArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageArea);
        this.messageTextLabel = new Label(messageArea, 0);
        this.messageTextLabel.setText(UITexts.ShelveDialog_messageLabel);
        this.messageTextBox = new Text(messageArea, 2626);
        GridData textBoxData = new GridData(768);
        textBoxData.heightHint = 100;
        this.messageTextBox.setLayoutData((Object)textBoxData);
        this.resourcesComposite = this.getBzrResourceSelectionComposite();
        Composite control = this.resourcesComposite.createControls(container);
        control.setLayoutData((Object)new GridData(1808));
        this.resourcesComposite.setResources(this.shelveableResources);
        this.resourcesComposite.setSelection(this.selectedResources);
        this.resourcesComposite.addUntrackedFilesFilterIfNoUntrackedSelected();
        this.resourcesComposite.refreshTableViewer();
        this.resourcesComposite.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ShelveDialog.this.enableOkButton();
            }
        });
        this.makeActions();
        return container;
    }

    private void makeActions() {
        if (this.wholeBranchEnabled) {
            this.wholeBranch.setSelection(false);
            this.wholeBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShelveDialog.this.resourcesComposite.getTableViewer().getTable().setEnabled(!ShelveDialog.this.wholeBranch.getSelection());
                    ShelveDialog.this.enableOkButton();
                }
            });
        }
    }

    public boolean isWholeBranch() {
        return this.isWholeBranch;
    }

    public String getMessage() {
        return this.message;
    }

    public void setWholeBranchEnabled(boolean enable) {
        this.wholeBranchEnabled = enable;
    }

    private void enableOkButton() {
        boolean enabled = !this.resourcesComposite.getSelection().isEmpty();
        this.getButton(0).setEnabled(enabled |= this.wholeBranchEnabled ? this.wholeBranch.getSelection() : false);
    }

    protected void okPressed() {
        this.selectedFiles = this.resourcesComposite.getSelection();
        this.isWholeBranch = this.wholeBranchEnabled ? this.wholeBranch.getSelection() : false;
        this.message = this.messageTextBox.getText();
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    private BzrResourceSelectionComposite getBzrResourceSelectionComposite() {
        return new BzrResourceSelectionComposite(true, true){

            protected String getUpperLabel() {
                return UITexts.ShelveDialog_resourceLabel;
            }

            protected void createOption(Composite optionComposite) {
                if (ShelveDialog.this.wholeBranchEnabled) {
                    ShelveDialog.this.wholeBranch = new Button(optionComposite, 32);
                    ShelveDialog.this.wholeBranch.setText(UITexts.ShelveDialog_wholeBranch);
                }
            }
        };
    }

    public List<IBzrResourceStatus> getSelectedFiles() {
        return this.selectedFiles;
    }

    public int open(List<IBzrResourceStatus> shelveableResources, List<IBzrResourceStatus> selectedResources, boolean shouldBlock) {
        this.setShellStyle(3184);
        this.setBlockOnOpen(shouldBlock);
        this.shelveableResources = shelveableResources;
        this.selectedResources = selectedResources;
        return this.open();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        ShelveDialog dialog = new ShelveDialog(shell);
        int exit = dialog.open(new ArrayList<IBzrResourceStatus>(0), new ArrayList<IBzrResourceStatus>(0), true);
        System.out.println("exit: " + exit);
    }
}

