/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarRevisionRange;
import org.vcs.bazaar.eclipse.core.history.BazaarBranchHistory;
import org.vcs.bazaar.eclipse.core.history.BazaarFileHistory;
import org.vcs.bazaar.eclipse.core.history.BazaarFileRevision;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.history.HistoryTreeViewer;

public class ShowLogDialog
extends TrayDialog {
    private TreeViewer viewer;
    private IBzrBranch branch;
    private IResource resource;
    private RefreshLog refreshLogJob;
    private BazaarRevisionRange selectedRevisions;
    private boolean range;

    private ShowLogDialog(Shell shell, boolean range) {
        super(shell);
        this.range = range;
        this.setShellStyle(2160);
    }

    public ShowLogDialog(Shell shell, IBzrBranch branch, boolean range) {
        this(shell, range);
        this.branch = branch;
    }

    public ShowLogDialog(Shell shell, IBzrBranch branch) {
        this(shell, false);
        this.branch = branch;
    }

    public ShowLogDialog(Shell shell, IResource resource) {
        this(shell, false);
        this.resource = resource;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.viewer = new HistoryTreeViewer(composite, (this.range ? 2 : 0) | 0x100 | 0x200, new HistoryTreeViewer.Column[0]);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ShowLogDialog.this.okPressed();
            }
        });
        this.refresh();
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(700, 400);
    }

    public BazaarRevision getSelectedRevision() {
        return this.selectedRevisions != null ? this.selectedRevisions.getStart() : null;
    }

    public String getSelectedRevisionAsString() {
        if (this.selectedRevisions != null) {
            if (this.selectedRevisions.getStart().equals((Object)this.selectedRevisions.getEnd())) {
                return this.selectedRevisions.getStart().getValue();
            }
            return String.format("%1$s..%2$s", this.selectedRevisions.getStart().getValue(), this.selectedRevisions.getEnd().getValue());
        }
        return null;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() > 0) {
            Object[] selected = selection.toArray();
            BazaarFileRevision rev1 = (BazaarFileRevision)selected[0];
            BazaarFileRevision rev2 = (BazaarFileRevision)selected[selected.length - 1];
            this.selectedRevisions = BazaarRevisionRange.getRange((BazaarRevision)rev2.getRevision(), (BazaarRevision)rev1.getRevision());
        }
        super.okPressed();
    }

    public void refresh() {
        if (this.branch != null || this.resource != null) {
            if (this.refreshLogJob == null) {
                this.refreshLogJob = new RefreshLog();
            }
            if (this.refreshLogJob.getState() != 0) {
                this.refreshLogJob.cancel();
            }
            this.refreshLogJob.setResource(this.branch);
            this.refreshLogJob.schedule();
        }
    }

    public boolean close() {
        if (this.refreshLogJob != null && this.refreshLogJob.getState() != 0) {
            this.refreshLogJob.cancel();
        }
        return super.close();
    }

    private class RefreshLog
    extends Job {
        private IBzrBranch branch;

        public RefreshLog() {
            super("Fetching Bazaar revisions...");
            this.setUser(true);
            this.setPriority(30);
        }

        public void setResource(IBzrBranch branch) {
            this.branch = branch;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            if (this.branch != null || ShowLogDialog.this.resource != null) {
                monitor.beginTask("", 1000);
                try {
                    try {
                        BazaarBranchHistory branchHistory = this.branch != null ? new BazaarBranchHistory(this.branch) : new BazaarFileHistory(ShowLogDialog.this.resource);
                        branchHistory.refresh(monitor, true);
                        if (!monitor.isCanceled()) {
                            ShowLogDialog.this.getShell().getDisplay().asyncExec(new Runnable((BazaarFileHistory)branchHistory){
                                private final /* synthetic */ BazaarFileHistory val$branchHistory;
                                {
                                    this.val$branchHistory = bazaarFileHistory;
                                }

                                public void run() {
                                    ShowLogDialog.this.viewer.setInput((Object)this.val$branchHistory);
                                }
                            });
                        }
                        monitor.worked(400);
                    }
                    catch (CoreException e) {
                        EclipseBazaarUI.log(e);
                        status = e.getStatus();
                        monitor.done();
                    }
                    catch (Exception e) {
                        EclipseBazaarUI.log((CoreException)((Object)BazaarException.wrapException((Exception)e)));
                        IStatus iStatus = UIJob.errorStatus((Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
            }
            return status;
        }
    }
}

