/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IMergeOptions;
import org.vcs.bazaar.client.commandline.syntax.ITagOptions;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.dialogs.ShowLogDialog;
import org.vcs.bazaar.eclipse.ui.widgets.RevisionNumber;

public class TagDialog
extends Dialog {
    IBzrBranch branch;
    private Text tagText;
    private Button force;
    private RevisionNumber revision;
    private String tagName;
    private List<Option> options;

    public TagDialog(Shell parentShell, IBzrBranch branch) {
        super(parentShell);
        this.branch = branch;
        this.setShellStyle(2160);
        this.setBlockOnOpen(true);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(UITexts.TagDialog_title);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Label tagLabel = new Label(container, 256);
        tagLabel.setText(UITexts.TagDialog_tagLabel);
        this.tagText = new Text(container, 2116);
        this.tagText.setLayoutData((Object)new GridData(768));
        Group optionGroup = new Group(container, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        optionGroup.setLayoutData((Object)data);
        optionGroup.setText(UITexts.Dialog_optionsGroup);
        optionGroup.setLayout((Layout)new GridLayout(1, false));
        this.force = new Button((Composite)optionGroup, 32);
        this.force.setText(UITexts.Dialog_optionForce);
        this.force.setToolTipText(UITexts.TagDialog_forceTooltip);
        this.force.setSelection(false);
        this.revision = new RevisionNumber((Composite)optionGroup);
        this.revision.addShowLogButtonSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagDialog.this.showLog();
            }
        });
        return container;
    }

    protected void showLog() {
        ShowLogDialog dialog;
        if (this.branch != null && (dialog = new ShowLogDialog(this.getShell(), this.branch)).open() == 0 && dialog.getSelectedRevision() != null) {
            this.revision.setRevision(dialog.getSelectedRevision().getValue());
        }
    }

    protected void okPressed() {
        this.tagName = this.tagText.getText();
        this.options = new ArrayList<Option>();
        if (this.force.getSelection()) {
            this.options.add(ITagOptions.FORCE);
        }
        if (this.revision.isRevisionSelected()) {
            this.options.add((Option)IMergeOptions.REVISION.setArgument(this.revision.getRevision()));
        }
        super.okPressed();
    }

    public String getTagName() {
        return this.tagName;
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[0]);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        TagDialog dialog = new TagDialog(shell, null);
        dialog.setBlockOnOpen(true);
        int exit = dialog.open();
        System.out.println("exit: " + exit + " " + dialog.getTagName() + " " + dialog.getOptions());
    }
}

