/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.vcs.bazaar.client.BazaarShelf;
import org.vcs.bazaar.client.IBazaarShelf;
import org.vcs.bazaar.eclipse.ui.UITexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnShelveDialog
extends Dialog {
    private List<IBazaarShelf> shelves;
    private TableViewer tableViewer;
    private Button dryRunButton;
    private Button keepButton;
    private Button deleteOnlyButton;
    private String shelfId;
    private boolean dryRun;
    private boolean keep;
    private boolean deleteOnly;

    public UnShelveDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UITexts.UnShelveDialog_title);
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.swtDefaults().applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        int tableStyle = 68354;
        Composite tablecontainer = new Composite(container, 0);
        Table table = new Table(tablecontainer, tableStyle);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout layout = new TableColumnLayout();
        tablecontainer.setLayout((Layout)layout);
        TableColumn file = new TableColumn(table, 16384);
        file.setResizable(true);
        file.setText(UITexts.UnShelveDialog_shelfId);
        layout.setColumnData((Widget)file, (ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn pattern = new TableColumn(table, 16384);
        pattern.setResizable(true);
        pattern.setText(UITexts.UnShelveDialog_message);
        layout.setColumnData((Widget)pattern, (ColumnLayoutData)new ColumnWeightData(90, true));
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ShelfListLabelProvider());
        this.tableViewer.setInput((Object)this.shelves.toArray(new IBazaarShelf[0]));
        if (!this.shelves.isEmpty()) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(this.shelves.subList(0, 1)));
        }
        GridDataFactory gf = GridDataFactory.fillDefaults().align(4, 4).grab(true, true);
        gf.applyTo((Control)tablecontainer);
        Group optionGroup = new Group(container, 0);
        optionGroup.setText(UITexts.Dialog_optionsGroup);
        optionGroup.setLayout((Layout)new GridLayout(2, true));
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)optionGroup);
        Composite composite = new Composite((Composite)optionGroup, 0);
        composite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)composite);
        this.dryRunButton = new Button(composite, 32);
        this.dryRunButton.setText(UITexts.UnShelveDialog_dryRun);
        this.dryRunButton.setToolTipText(UITexts.UnShelveDialog_dryRunTooltip);
        this.dryRunButton.setSelection(false);
        this.keepButton = new Button(composite, 32);
        this.keepButton.setText(UITexts.UnShelveDialog_keep);
        this.keepButton.setToolTipText(UITexts.UnShelveDialog_keepTooltip);
        this.keepButton.setSelection(false);
        composite = new Composite((Composite)optionGroup, 0);
        composite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)composite);
        this.deleteOnlyButton = new Button(composite, 32);
        this.deleteOnlyButton.setText(UITexts.UnShelveDialog_deleteOnly);
        this.deleteOnlyButton.setToolTipText(UITexts.UnShelveDialog_deleteOnlyTooltip);
        this.deleteOnlyButton.setSelection(false);
        return container;
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        this.shelfId = !sel.isEmpty() ? ((IBazaarShelf)sel.getFirstElement()).getId() : null;
        this.dryRun = this.dryRunButton.getSelection();
        this.keep = this.keepButton.getSelection();
        this.deleteOnly = this.deleteOnlyButton.getSelection();
        super.okPressed();
    }

    public String getShelfId() {
        return this.shelfId;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public boolean isDeleteOnly() {
        return this.deleteOnly;
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    public int open(List<IBazaarShelf> shelves) {
        this.shelves = shelves;
        return super.open();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        BazaarShelf shelf1 = new BazaarShelf("1", "shelf 1");
        BazaarShelf shelf2 = new BazaarShelf("2", "shelf 2");
        ArrayList<IBazaarShelf> shelves = new ArrayList<IBazaarShelf>();
        shelves.add((IBazaarShelf)shelf1);
        shelves.add((IBazaarShelf)shelf2);
        UnShelveDialog dialog = new UnShelveDialog(shell);
        int exit = dialog.open(shelves);
        System.out.println("exit: " + exit);
    }

    private static class ShelfListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ShelfListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IBazaarShelf) {
                switch (columnIndex) {
                    case 0: {
                        return ((IBazaarShelf)element).getId();
                    }
                    case 1: {
                        return ((IBazaarShelf)element).getMessage();
                    }
                }
            }
            return "N/A";
        }
    }
}

