/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.text.SimpleDateFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.vcs.bazaar.client.IBazaarLogMessage;

public class UncommitDialog
extends MessageDialog {
    private IBazaarLogMessage log;

    public UncommitDialog(Shell parentShell, IBazaarLogMessage log) {
        super(parentShell, UncommitDialog.getTitle(log), null, UncommitDialog.getMessage(log), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.log = log;
    }

    static String getMessage(IBazaarLogMessage log) {
        return "The specified revision(s) will be removed. " + System.getProperty("line.separator") + "Are you sure?";
    }

    static String getTitle(IBazaarLogMessage log) {
        return "Confirm uncommit";
    }

    protected Control createCustomArea(Composite parent) {
        Point defaultMargins = LayoutConstants.getMargins();
        Composite contents = new Composite(parent, 16);
        contents.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(contents, 16384).setText("Revno:");
        new Label(contents, 16384).setText(this.log.getRevision().getValue());
        new Label(contents, 16384).setText("Commiter:");
        new Label(contents, 16384).setText(this.log.getCommiter().trim());
        new Label(contents, 16384).setText("Date:");
        new Label(contents, 16384).setText(new SimpleDateFormat("yyyy-MM-dd").format(this.log.getDate()).trim());
        Group messageGroup = new Group(contents, 0);
        messageGroup.setText("Message");
        GridLayoutFactory.fillDefaults().numColumns(1).margins(defaultMargins.x, defaultMargins.y).applyTo((Composite)messageGroup);
        messageGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label label = new Label((Composite)messageGroup, 16448);
        label.setText(this.log.getMessage().trim());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)label);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargins.x, defaultMargins.y).applyTo(contents);
        return contents;
    }
}

