/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.history;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;

public class AffectedPathsItem
extends FileRevision {
    private final IBzrBranch branch;
    private final IBazaarStatus status;
    private final BazaarRevision revision;
    private final IResource resource;
    IStorageBazaarRevision storageBazaarRevision;
    private final boolean selected;

    public AffectedPathsItem(IBzrBranch branch, IBazaarStatus status, BazaarRevision revision, boolean selected) {
        this.branch = branch;
        this.status = status;
        this.revision = revision;
        this.selected = selected;
        IPath path = branch.getPath().append(status.getPath());
        this.resource = ResourceUtil.getIResource((IPath)path, (boolean)status.isDirectory());
    }

    public IBazaarStatus getStatus() {
        return this.status;
    }

    public BazaarRevision getRevision() {
        return this.revision;
    }

    public IStorageBazaarRevision getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.storageBazaarRevision == null) {
            this.storageBazaarRevision = new IStorageBazaarRevision(this.resource, this.branch, this.status.getPath(), this.revision);
        }
        return this.storageBazaarRevision;
    }

    public String getName() {
        return this.status.getPath();
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getContentIdentifier() {
        return this.revision.toString();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public IResource getResource() {
        return this.resource;
    }
}

