/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.history;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.eclipse.ui.UIUtils;
import org.vcs.bazaar.eclipse.ui.decorator.DecoratorImages;
import org.vcs.bazaar.eclipse.ui.history.AffectedPathsItem;

public class AffectedPathsLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public Image getImage(IBazaarStatus status) {
        ImageDescriptor id = UIUtils.getEditorImage(status);
        Image base = (Image)this.resourceManager.get((DeviceResourceDescriptor)id);
        if (status.contains(BazaarStatusKind.CREATED) || status.contains(BazaarStatusKind.DELETED) || status.contains(BazaarStatusKind.RENAMED)) {
            DecorationOverlayIcon im = new DecorationOverlayIcon(base, DecoratorImages.getImageDescriptor(status), 3);
            base = (Image)this.resourceManager.get((DeviceResourceDescriptor)im);
        }
        return base;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof AffectedPathsItem)) {
            return null;
        }
        IBazaarStatus status = ((AffectedPathsItem)((Object)element)).getStatus();
        return this.getImage(status);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof AffectedPathsItem)) {
            return "Type Error";
        }
        IBazaarStatus status = ((AffectedPathsItem)((Object)element)).getStatus();
        return status.getPath();
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    public Color getForeground(Object element, int columnIndex) {
        if (!(element instanceof AffectedPathsItem)) {
            return null;
        }
        if (!((AffectedPathsItem)((Object)element)).isSelected()) {
            return Display.getDefault().getSystemColor(15);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

