/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.history;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.eclipse.core.commands.LogCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.AbstractCompareAction;
import org.vcs.bazaar.eclipse.ui.actions.OpenBazaarRevisionAction;
import org.vcs.bazaar.eclipse.ui.compare.CompareUtils;
import org.vcs.bazaar.eclipse.ui.history.AffectedPathsItem;
import org.vcs.bazaar.eclipse.ui.history.AffectedPathsLabelProvider;
import org.vcs.bazaar.eclipse.ui.history.BazaarHistoryPageInput;

public class AffectedPathsViewer
extends TableViewer {
    private IWorkbenchSite site;
    private IBzrResource resource;
    private final Set<IPath> selectedPaths;
    private final Map<BazaarRevision, List<AffectedPathsItem>> cache;

    public AffectedPathsViewer(Composite parent, IWorkbenchSite site, BazaarHistoryPageInput input) {
        super(parent);
        this.site = site;
        this.cache = new ConcurrentHashMap<BazaarRevision, List<AffectedPathsItem>>();
        this.selectedPaths = new HashSet<IPath>();
        this.getTable().setLinesVisible(true);
        this.setLabelProvider((IBaseLabelProvider)new AffectedPathsLabelProvider());
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object element1, Object element2) {
                TableViewer tableViewer = (TableViewer)viewer;
                ITableLabelProvider labelProvider = (ITableLabelProvider)tableViewer.getLabelProvider();
                String l1 = labelProvider.getColumnText(element1, 0);
                String l2 = labelProvider.getColumnText(element2, 0);
                int result = l1.compareTo(l2);
                return result;
            }
        });
        this.setInput(input);
        if (this.resource.getBranch().isProjectBranch()) {
            MenuManager mgr = new MenuManager();
            Control c = this.getControl();
            c.setMenu(mgr.createContextMenu(c));
            final OpenBazaarRevisionAction openAction = new OpenBazaarRevisionAction(UITexts.ActionOpenInEditor_label, site){

                protected boolean shouldShow() {
                    AffectedPathsItem item;
                    if (this.selection.size() == 1 && !(item = (AffectedPathsItem)((Object)this.selection.getFirstElement())).getStatus().isDirectory()) {
                        return super.shouldShow();
                    }
                    return false;
                }
            };
            final AbstractCompareAction compareWithPreviousAction = new AbstractCompareAction(UITexts.ActionCompareWithPrevious_label){

                public void internalRun() {
                    try {
                        IStructuredSelection selection = this.getStructuredSelection();
                        AffectedPathsItem item = (AffectedPathsItem)((Object)selection.getFirstElement());
                        if (!item.getStatus().isDirectory()) {
                            IStorageBazaarRevision storage = item.getStorage(null);
                            BazaarRevision previousRev = BazaarRevision.getRevision((BazaarRevision.Prefix)BazaarRevision.Prefix.BEFORE, (String)item.getRevision().toString());
                            CompareUtils.openEditor(item.getResource(), storage, new IStorageBazaarRevision(storage, previousRev));
                        }
                    }
                    catch (CoreException e) {
                        EclipseBazaarUI.log(e);
                    }
                }

                protected boolean shouldShow(IStructuredSelection selection) {
                    if (selection.size() == 1) {
                        AffectedPathsItem item = (AffectedPathsItem)((Object)selection.getFirstElement());
                        return !item.getStatus().isDirectory() && item.getStatus().contains(BazaarStatusKind.MODIFIED);
                    }
                    return false;
                }
            };
            this.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)AffectedPathsViewer.this.getSelection();
                    openAction.selectionChanged(selection);
                    compareWithPreviousAction.selectionChanged(selection);
                }
            });
            this.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    AffectedPathsItem item = (AffectedPathsItem)((Object)selection.getFirstElement());
                    if (!item.getStatus().isDirectory()) {
                        openAction.selectionChanged(selection);
                        openAction.run();
                    }
                }
            });
            mgr.add((IAction)openAction);
            mgr.add((IAction)compareWithPreviousAction);
        }
    }

    public void setInput(BazaarHistoryPageInput input) {
        this.selectedPaths.clear();
        this.cache.clear();
        if (input != null) {
            this.resource = input.getResource();
            if (input.getSelectedResources() != null) {
                IResource[] iResourceArray = input.getSelectedResources();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    this.selectedPaths.add(r.getLocation());
                    ++n2;
                }
            }
        }
        super.setInput((Object)input);
    }

    public void setRevision(final BazaarRevision revision) {
        if (revision == null) {
            this.setInput(null);
            this.refresh();
        } else if (this.cache.get(revision) == null) {
            final ArrayList input = new ArrayList();
            Job job = new Job("Fetching affected paths..."){

                protected IStatus run(IProgressMonitor monitor) {
                    LogCommand lcmd = new LogCommand(AffectedPathsViewer.this.resource, (IBazaarRevisionSpec)revision, true);
                    try {
                        lcmd.run(monitor);
                        List messages = lcmd.getLogMessages();
                        IBzrBranch branch = AffectedPathsViewer.this.resource.getBranch();
                        IPath branchPath = branch.getPath();
                        if (!messages.isEmpty()) {
                            IBazaarLogMessage message = (IBazaarLogMessage)messages.get(0);
                            for (IBazaarStatus status : message.getAffectedFiles()) {
                                boolean selected = true;
                                if (branchPath != null && !AffectedPathsViewer.this.selectedPaths.isEmpty()) {
                                    selected = false;
                                    for (IPath path : AffectedPathsViewer.this.selectedPaths) {
                                        if (!path.isPrefixOf(branchPath.append(status.getPath()))) continue;
                                        selected = true;
                                        break;
                                    }
                                }
                                input.add(new AffectedPathsItem(branch, status, revision, selected));
                            }
                        }
                    }
                    catch (BazaarException bazaarException) {}
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        AffectedPathsViewer.this.site.getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                AffectedPathsViewer.this.cache.put(revision, input);
                                AffectedPathsViewer.this.setInput(input);
                                AffectedPathsViewer.this.refresh();
                            }
                        });
                    }
                }
            });
            job.setUser(true);
            job.setPriority(30);
            job.schedule();
        } else {
            this.setInput(this.cache.get(revision));
            this.refresh();
        }
    }
}

