/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.history;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.history.BazaarBranchHistory;
import org.vcs.bazaar.eclipse.core.history.BazaarFileHistory;
import org.vcs.bazaar.eclipse.core.history.BazaarFileRevision;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.BzrTeamStatus;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UIIcons;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.AbstractCompareAction;
import org.vcs.bazaar.eclipse.ui.actions.OpenBazaarRevisionAction;
import org.vcs.bazaar.eclipse.ui.compare.CompareUtils;
import org.vcs.bazaar.eclipse.ui.history.AffectedPathsViewer;
import org.vcs.bazaar.eclipse.ui.history.BazaarHistoryPageInput;
import org.vcs.bazaar.eclipse.ui.history.HistoryTreeViewer;

public class BazaarHistoryPage
extends HistoryPage {
    private BazaarHistoryPageInput input;
    private TreeViewer viewer;
    private SashForm control;
    private LogTreeContentProvider logTreeContentProvider;
    private BazaarFileHistory bazaarFileHistory;
    private AffectedPathsViewer pathsViewer;
    private final IPreferenceStore store;
    private boolean showPaths;
    private RefreshBazaarHistory refreshFileHistoryJob;
    private BazaarRevision selectedRevision;

    public BazaarHistoryPage(BazaarHistoryPageInput input) {
        this.input = input;
        this.store = EclipseBazaarUI.getDefault().getPreferenceStore();
        this.showPaths = this.store.getBoolean("pref_history_show_affected_paths");
    }

    public boolean setInput(BazaarHistoryPageInput input) {
        this.input = input;
        this.pathsViewer.setInput(input);
        return super.setInput((Object)input);
    }

    public boolean inputSet() {
        if (this.isValidInput(this.getInput())) {
            IResource resource = this.getIResource();
            this.bazaarFileHistory = resource != null ? new BazaarFileHistory(resource) : new BazaarBranchHistory(this.input.getResource().getBranch());
            this.fetchRevisions(this.bazaarFileHistory, false);
            return true;
        }
        return false;
    }

    private IResource getIResource() {
        if (this.input.getResource() instanceof IBzrLocalResource) {
            return ((IBzrLocalResource)this.input.getResource()).getIResource();
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.control = new SashForm(parent, 512);
        this.control.setLayoutData((Object)new GridData(1808));
        this.viewer = new HistoryTreeViewer((Composite)this.control, new HistoryTreeViewer.Column[0]);
        this.pathsViewer = new AffectedPathsViewer((Composite)this.control, (IWorkbenchSite)this.getSite(), this.input);
        this.contributeActions();
        this.layout();
    }

    private void setContentProvider() {
        if (this.logTreeContentProvider == null) {
            this.logTreeContentProvider = new LogTreeContentProvider();
        }
        this.viewer.setContentProvider((IContentProvider)this.logTreeContentProvider);
    }

    private void contributeActions() {
        final OpenBazaarRevisionAction openAction = new OpenBazaarRevisionAction(UITexts.ActionOpenInEditor_label, (IWorkbenchSite)this.getSite()){

            protected boolean shouldShow() {
                return BazaarHistoryPage.this.getIResource() instanceof IFile;
            }
        };
        final AbstractCompareAction compareWithCurrentAction = new AbstractCompareAction(UITexts.ActionCompareWithCurrent_label){

            public void internalRun() {
                try {
                    IResource resource = BazaarHistoryPage.this.getIResource();
                    if (resource instanceof IFile) {
                        CompareUtils.openSaveableEditor(resource, this.getStorage(0), null);
                    } else if (resource instanceof IResource) {
                        this.openEditor(resource, this.getRevision(0).getRevision());
                    } else {
                        this.openEditor(BazaarHistoryPage.this.input.getResource().getBranch(), this.getRevision(0).getRevision());
                    }
                }
                catch (CoreException e) {
                    EclipseBazaarUI.log(e);
                }
            }

            protected boolean shouldShow(IStructuredSelection selection) {
                return selection.size() == 1;
            }
        };
        final AbstractCompareAction compareWithEachOther = new AbstractCompareAction(UITexts.ActionCompareWithEachOther_label){

            public void internalRun() {
                try {
                    IResource resource = BazaarHistoryPage.this.getIResource();
                    if (resource instanceof IFile) {
                        CompareUtils.openEditor(resource, this.getStorage(0), this.getStorage(1));
                    } else if (resource instanceof IResource) {
                        this.openEditor(resource, this.getRevision(1).getRevision(), this.getRevision(0).getRevision());
                    } else {
                        this.openEditor(BazaarHistoryPage.this.input.getResource().getBranch(), this.getRevision(0).getRevision(), this.getRevision(1).getRevision());
                    }
                }
                catch (CoreException e) {
                    EclipseBazaarUI.log(e);
                }
            }

            public boolean shouldShow(IStructuredSelection selection) {
                return selection.size() == 2;
            }
        };
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BazaarHistoryPage.this.viewer.getSelection();
                openAction.selectionChanged(selection);
                compareWithCurrentAction.selectionChanged(selection);
                compareWithEachOther.selectionChanged(selection);
                if (selection.size() == 1) {
                    BazaarFileRevision rev = (BazaarFileRevision)selection.getFirstElement();
                    BazaarHistoryPage.this.selectedRevision = rev.getRevision();
                } else {
                    BazaarHistoryPage.this.selectedRevision = null;
                }
                if (BazaarHistoryPage.this.showPaths) {
                    BazaarHistoryPage.this.pathsViewer.setRevision(BazaarHistoryPage.this.selectedRevision);
                }
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (BazaarHistoryPage.this.getIResource() instanceof IFile) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    openAction.selectionChanged(selection);
                    openAction.run();
                }
            }
        });
        if (this.input.getResource().getBranch().isProjectBranch()) {
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager menuMgr) {
                    menuMgr.add((IContributionItem)new Separator("group.file"));
                    menuMgr.add((IAction)openAction);
                    menuMgr.add((IAction)compareWithCurrentAction);
                    menuMgr.add((IAction)compareWithEachOther);
                }
            });
            menuMgr.setRemoveAllWhenShown(true);
            this.viewer.getTree().setMenu(menu);
        }
        this.contributeToActionBars();
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
    }

    public String getDescription() {
        return this.getName();
    }

    public String getName() {
        IResource resource = this.getIResource();
        if (resource != null) {
            return resource.getFullPath().toOSString();
        }
        return this.input.getResource().getName();
    }

    public boolean isValidInput(Object object) {
        return object instanceof BazaarHistoryPageInput;
    }

    public void refresh() {
        this.fetchRevisions(this.bazaarFileHistory, false);
    }

    private void fetchRevisions(final BazaarFileHistory bazaarFileHistory, boolean append) {
        if (this.isValidInput(this.getInput()) && this.getControl() != null) {
            boolean canceled = true;
            if (this.refreshFileHistoryJob != null && this.refreshFileHistoryJob.getState() != 0) {
                canceled = this.refreshFileHistoryJob.cancel();
            }
            if (canceled) {
                this.refreshFileHistoryJob = new RefreshBazaarHistory(bazaarFileHistory, append);
                this.refreshFileHistoryJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            BazaarHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    BazaarHistoryPage.this.viewer.setInput((Object)bazaarFileHistory);
                                }
                            });
                        }
                    }
                });
                this.refreshFileHistoryJob.setRule((ISchedulingRule)(this.getIResource() != null ? this.getIResource().getProject() : ResourcesPlugin.getWorkspace().getRoot()));
                this.refreshFileHistoryJob.schedule();
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private void layout() {
        if (this.showPaths) {
            this.control.setMaximizedControl(null);
        } else {
            this.control.setMaximizedControl((Control)this.viewer.getControl().getParent());
        }
    }

    public void dispose() {
        if (this.refreshFileHistoryJob != null && this.refreshFileHistoryJob.getState() != 0) {
            this.refreshFileHistoryJob.cancel();
        }
        super.dispose();
    }

    private void contributeToActionBars() {
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        IPageSite pageSite = parentSite.getWorkbenchPageSite();
        IActionBars actionBars = pageSite.getActionBars();
        Action toggleShowAffectedPathsAction = new Action(UITexts.HistoryView_ShowAffectedPaths, UIIcons.AFFECTED_PATHS){

            public void run() {
                BazaarHistoryPage.this.showPaths = this.isChecked();
                BazaarHistoryPage.this.store.setValue("pref_history_show_affected_paths", BazaarHistoryPage.this.showPaths);
                if (BazaarHistoryPage.this.showPaths) {
                    BazaarHistoryPage.this.pathsViewer.setRevision(BazaarHistoryPage.this.selectedRevision);
                }
                BazaarHistoryPage.this.layout();
            }
        };
        toggleShowAffectedPathsAction.setChecked(this.showPaths);
        Action showMoreAction = new Action(UITexts.HistoryView_GetMoreRevisions, UIIcons.GET_NEXT){

            public void run() {
                BazaarHistoryPage.this.fetchRevisions(BazaarHistoryPage.this.bazaarFileHistory, true);
            }
        };
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)toggleShowAffectedPathsAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)showMoreAction);
        tbm.update(false);
        actionBars.updateActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        actionBarsMenu.add((IAction)toggleShowAffectedPathsAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        ArrayList<BazaarHistoryPageFilterAction> allFilters = new ArrayList<BazaarHistoryPageFilterAction>();
        BazaarHistoryPageFilterAction resourceFilter = new BazaarHistoryPageFilterAction(this, ShowFilter.RESOURCE, null, UITexts.HistoryView_AllOfResourceMenuLabel, UITexts.HistoryView_AllOfResourceTooltip);
        resourceFilter.setChecked(true);
        allFilters.add(resourceFilter);
        BazaarHistoryPageFilterAction parentFilter = new BazaarHistoryPageFilterAction(this, ShowFilter.PARENT, null, UITexts.HistoryView_AllInParentMenuLabel, UITexts.HistoryView_AllInParentTooltip);
        allFilters.add(parentFilter);
        BazaarHistoryPageFilterAction projectFilter = new BazaarHistoryPageFilterAction(this, ShowFilter.PROJECT, null, UITexts.HistoryView_AllInProjectMenuLabel, UITexts.HistoryView_AllInProjectTooltip);
        allFilters.add(projectFilter);
        BazaarHistoryPageFilterAction branchFilter = new BazaarHistoryPageFilterAction(this, ShowFilter.BRANCH, null, UITexts.HistoryView_AllInBranchMenuLabel, UITexts.HistoryView_AllInBranchTooltip);
        allFilters.add(branchFilter);
        for (BazaarHistoryPageFilterAction action : allFilters) {
            actionBarsMenu.add((IAction)action);
            action.setAllFilterActions(allFilters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BazaarHistoryPageFilterAction
    extends Action {
        private final ShowFilter filter;
        private final BazaarHistoryPage historyPage;
        private List<BazaarHistoryPageFilterAction> allFilterActions;

        public BazaarHistoryPageFilterAction(BazaarHistoryPage historyPage, ShowFilter filter, ImageDescriptor icon, String menuLabel, String toolTipText) {
            super(null, 8);
            this.historyPage = historyPage;
            this.filter = filter;
            this.setImageDescriptor(icon);
            this.setText(menuLabel);
            this.setToolTipText(toolTipText);
        }

        public void run() {
            if (this.isChecked()) {
                for (BazaarHistoryPageFilterAction action : this.allFilterActions) {
                    if (action == this) continue;
                    action.setChecked(false);
                }
                if (BazaarHistoryPage.this.input != null && BazaarHistoryPage.this.input.getSelectedResources() != null && BazaarHistoryPage.this.input.getSelectedResources().length == 1) {
                    BazaarHistoryPageInput newInput = null;
                    IResource selected = BazaarHistoryPage.this.input.getSelectedResources()[0];
                    IBzrLocalResource resource = null;
                    if (this.filter == ShowFilter.RESOURCE) {
                        resource = BzrWorkspaceRoot.getBzrResourceFor((IResource)selected);
                    } else if (this.filter == ShowFilter.PARENT && (selected.getType() == 2 || selected.getType() == 1)) {
                        resource = BzrWorkspaceRoot.getBzrResourceFor((IResource)selected.getParent());
                    } else if (this.filter == ShowFilter.PROJECT) {
                        resource = BzrWorkspaceRoot.getBzrResourceFor((IResource)selected.getProject());
                    } else if (this.filter == ShowFilter.BRANCH) {
                        resource = BzrWorkspaceRoot.getBranchFor((IProject)selected.getProject());
                    }
                    newInput = new BazaarHistoryPageInput((IBzrResource)resource, BazaarHistoryPage.this.input.getSelectedResources());
                    String oldName = this.historyPage.getName();
                    String oldDescription = this.historyPage.getDescription();
                    this.historyPage.setInput(newInput);
                    this.historyPage.firePropertyChange((Object)this.historyPage, "org.eclipse.team.ui.name", oldName, this.historyPage.getName());
                    this.historyPage.firePropertyChange((Object)this.historyPage, "org.eclipse.team.ui.description", oldDescription, this.historyPage.getDescription());
                }
            }
        }

        public void setAllFilterActions(List<BazaarHistoryPageFilterAction> allFilterActions) {
            this.allFilterActions = allFilterActions;
        }
    }

    class LogTreeContentProvider
    implements ITreeContentProvider {
        LogTreeContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((IFileHistory)parent).getFileRevisions();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BazaarFileRevision) {
                return ((BazaarFileRevision)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof BazaarFileRevision && ((BazaarFileRevision)element).hasParent()) {
                return ((BazaarFileRevision)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BazaarFileRevision) {
                BazaarFileRevision revision = (BazaarFileRevision)element;
                return revision.hasChildren();
            }
            return false;
        }
    }

    private class RefreshBazaarHistory
    extends Job {
        private final BazaarFileHistory bazaarFileHistory;
        private final boolean append;

        public RefreshBazaarHistory(BazaarFileHistory bazaarFileHistory, boolean append) {
            super("Fetching Bazaar revisions...");
            this.setUser(true);
            this.setPriority(30);
            this.bazaarFileHistory = bazaarFileHistory;
            this.append = append;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            if (this.bazaarFileHistory != null) {
                monitor.beginTask(this.getName(), 1000);
                try {
                    try {
                        if (!this.append) {
                            this.bazaarFileHistory.refresh(monitor, true);
                        } else {
                            this.bazaarFileHistory.loadMore(monitor);
                        }
                        if (BazaarHistoryPage.this.viewer.getContentProvider() == null) {
                            BazaarHistoryPage.this.setContentProvider();
                        }
                    }
                    catch (CoreException e) {
                        EclipseBazaarUI.log(e);
                        status = e.getStatus();
                        monitor.done();
                    }
                    catch (Exception e) {
                        EclipseBazaarUI.log((CoreException)((Object)BazaarException.wrapException((Exception)e)));
                        status = new BzrTeamStatus(4, e.getMessage(), (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
            return status;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ShowFilter {
        RESOURCE,
        PARENT,
        PROJECT,
        BRANCH;

    }
}

