/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.history;

import java.text.DateFormat;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.core.history.IFileHistory;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.eclipse.core.history.BazaarFileRevision;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.UIUtils;

public class HistoryTreeViewer
extends TreeViewer {
    private static Column[] defaultColumns = new Column[]{Column.REVNO, Column.MESSAGE, Column.COMMITTER, Column.TIMESTAMP, Column.BRANCH_NICK};

    public HistoryTreeViewer(Composite parent, Column ... columns) {
        this(parent, 770, columns);
    }

    public HistoryTreeViewer(Composite parent, int style, Column ... columns) {
        super(new Tree(new Composite(parent, 0), style | 0x10000));
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = true;
        this.getControl().getParent().setLayoutData((Object)gdata);
        Tree tree = HistoryTreeViewer.configureTree(this.getTree().getParent(), this.getTree(), columns);
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            Object labelProvider = null;
            Object data = column.getData();
            if (data == Column.REVNO || data == Column.REVID) {
                labelProvider = new RevisionColumnLabelProvider();
            } else if (data == Column.MESSAGE) {
                labelProvider = new MessageColumnLabelProvider();
            } else if (data == Column.COMMITTER) {
                labelProvider = new CommitterColumnLabelProvider();
            } else if (data == Column.TIMESTAMP) {
                labelProvider = new DateColumnLabelProvider();
            } else if (data == Column.BRANCH_NICK) {
                labelProvider = new BranchNickColumnLabelProvider();
            }
            if (labelProvider != null) {
                new TreeViewerColumn((TreeViewer)this, column).setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
        this.setSorter(new RevisionSorter());
        this.setContentProvider((IContentProvider)new LogTreeContentProvider());
    }

    private static Tree configureTree(Composite parent, Tree logTree, Column ... columns) {
        if (columns == null || columns.length == 0) {
            columns = defaultColumns;
        }
        logTree.setLinesVisible(true);
        logTree.setHeaderVisible(true);
        TreeColumnLayout layout = new TreeColumnLayout();
        parent.setLayout((Layout)layout);
        int i = 0;
        while (i < columns.length) {
            Column col = columns[i];
            TreeColumn column = null;
            if (col.equals((Object)Column.REVNO)) {
                column = new TreeColumn(logTree, 16384);
                column.setText(UITexts.HistoryView_HeaderRevision);
                layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(5, true));
                column.setData((Object)Column.REVNO);
            } else if (col.equals((Object)Column.REVID)) {
                column = new TreeColumn(logTree, 16384);
                column.setText(UITexts.HistoryView_HeaderRevId);
                layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(10, true));
                column.setData((Object)Column.REVID);
            } else if (col.equals((Object)Column.TAGS)) {
                column = new TreeColumn(logTree, 16384);
                column.setText(UITexts.HistoryView_HeaderTags);
                layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(10, true));
                column.setData((Object)Column.TAGS);
            } else if (col.equals((Object)Column.COMMITTER)) {
                column = new TreeColumn(logTree, 16384);
                column.setText(UITexts.HistoryView_HeaderCommitter);
                layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(13, true));
                column.setData((Object)Column.COMMITTER);
            } else if (col.equals((Object)Column.TIMESTAMP)) {
                column = new TreeColumn(logTree, 16384);
                column.setText(UITexts.HistoryView_HeaderDate);
                column.setData((Object)Column.TIMESTAMP);
                layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(10, true));
            } else if (col.equals((Object)Column.BRANCH_NICK)) {
                column = new TreeColumn(logTree, 16384);
                column.setText(UITexts.HistoryView_HeaderBranchNick);
                layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(7, true));
                column.setData((Object)Column.BRANCH_NICK);
            } else if (col.equals((Object)Column.MESSAGE)) {
                column = new TreeColumn(logTree, 16384);
                column.setText(UITexts.HistoryView_HeaderMessage);
                layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, true));
                column.setData((Object)Column.MESSAGE);
            }
            column.setResizable(i < columns.length - 1);
            UIUtils.addSizeLimiter(column);
            ++i;
        }
        return logTree;
    }

    protected static class BranchNickColumnLabelProvider
    extends ColumnLabelProvider {
        protected BranchNickColumnLabelProvider() {
        }

        public String getText(Object obj) {
            BazaarFileRevision bazaarFileRevision = (BazaarFileRevision)obj;
            IBazaarLogMessage logMessage = bazaarFileRevision.getIBazaarLogMessage();
            return logMessage.getBranchNick();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        REVNO,
        REVID,
        TAGS,
        COMMITTER,
        TIMESTAMP,
        BRANCH_NICK,
        MESSAGE;

    }

    protected static class CommitterColumnLabelProvider
    extends ColumnLabelProvider {
        protected CommitterColumnLabelProvider() {
        }

        public String getText(Object obj) {
            BazaarFileRevision bazaarFileRevision = (BazaarFileRevision)obj;
            IBazaarLogMessage logMessage = bazaarFileRevision.getIBazaarLogMessage();
            return logMessage.getCommiter();
        }
    }

    protected static class DateColumnLabelProvider
    extends ColumnLabelProvider {
        private static final DateFormat df = DateFormat.getInstance();

        protected DateColumnLabelProvider() {
        }

        public String getText(Object obj) {
            BazaarFileRevision bazaarFileRevision = (BazaarFileRevision)obj;
            IBazaarLogMessage logMessage = bazaarFileRevision.getIBazaarLogMessage();
            return df.format(logMessage.getDate());
        }
    }

    protected static class LogTreeContentProvider
    implements ITreeContentProvider {
        protected LogTreeContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            IFileHistory fileHistory = (IFileHistory)parent;
            return fileHistory.getFileRevisions();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BazaarFileRevision) {
                return ((BazaarFileRevision)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof BazaarFileRevision && ((BazaarFileRevision)element).hasParent()) {
                return ((BazaarFileRevision)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BazaarFileRevision) {
                BazaarFileRevision revision = (BazaarFileRevision)element;
                return revision.hasChildren();
            }
            return false;
        }
    }

    protected static class MessageColumnLabelProvider
    extends DelegatingStyledCellLabelProvider {
        public MessageColumnLabelProvider() {
            super(new DelegatingStyledCellLabelProvider.IStyledLabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public StyledString getStyledText(Object element) {
                    StyledString string = new StyledString();
                    BazaarFileRevision bazaarFileRevision = (BazaarFileRevision)element;
                    IBazaarLogMessage logMessage = bazaarFileRevision.getIBazaarLogMessage();
                    if (logMessage.getTags() != null && !logMessage.getTags().isEmpty()) {
                        StringBuilder tags = new StringBuilder();
                        for (String tag : logMessage.getTags()) {
                            tags.append("[").append(tag).append("]");
                        }
                        string.append(tags.toString(), StyledString.DECORATIONS_STYLER);
                        string.append(" ");
                    }
                    string.append(logMessage.getMessage());
                    return string;
                }

                public Image getImage(Object element) {
                    return null;
                }
            });
        }
    }

    protected static class RevisionColumnLabelProvider
    extends ColumnLabelProvider {
        protected RevisionColumnLabelProvider() {
        }

        public String getText(Object obj) {
            BazaarFileRevision bazaarFileRevision = (BazaarFileRevision)obj;
            IBazaarLogMessage logMessage = bazaarFileRevision.getIBazaarLogMessage();
            String ret = logMessage.getRevision().getValue();
            ret = ret == null || ret.trim().isEmpty() ? logMessage.getRevisionId() : ret;
            return ret;
        }
    }

    protected static class RevisionSorter
    extends ViewerSorter {
        protected RevisionSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof BazaarFileRevision) || !(e1 instanceof BazaarFileRevision)) {
                return super.compare(viewer, e1, e2);
            }
            BazaarFileRevision revision1 = (BazaarFileRevision)e1;
            BazaarFileRevision revision2 = (BazaarFileRevision)e2;
            return revision2.compareRevisionTo(revision1);
        }
    }
}

