/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TeamAction
extends ActionDelegate
implements IObjectActionDelegate,
IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;
    private Shell shell;
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;
    private IWorkbenchPart targetPart;
    private IWorkbenchWindow window;
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                TeamAction.this.selection = (IStructuredSelection)selection;
            }
        }
    };

    public static Object getAdapter(Object adaptable, Class<?> c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    protected IProject[] getSelectedProjects() {
        IResource[] selectedResources = this.getSelectedResources();
        if (selectedResources.length == 0) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IResource[] iResourceArray = selectedResources;
        int n = selectedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 4) {
                projects.add((IProject)resource);
            }
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    protected IResource[] getSelectedResources() {
        return Utils.getContributedResources((Object[])this.getSelection().toArray());
    }

    protected IStructuredSelection getSelection() {
        if (this.selection == null) {
            this.selection = StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    protected Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        if (this.targetPart != null) {
            return this.targetPart.getSite().getShell();
        }
        if (this.window != null) {
            return this.window.getShell();
        }
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    protected final void run(final IRunnableWithProgress runnable, String problemMessage, int progressKind) {
        final Exception[] exceptions = new Exception[1];
        switch (progressKind) {
            case 2: {
                Display display = EclipseBazaarUI.getStandardDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException interruptedException) {
                            exceptions[0] = null;
                        }
                    }
                });
                break;
            }
            default: {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
                    break;
                }
                catch (InvocationTargetException e) {
                    exceptions[0] = e;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    exceptions[0] = null;
                }
            }
        }
        if (exceptions[0] != null) {
            this.handle(exceptions[0], null, problemMessage);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            if (action != null) {
                this.setActionEnablement(action);
            }
        }
    }

    protected void setActionEnablement(IAction action) {
        try {
            action.setEnabled(this.isEnabled());
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() == 274) {
                action.setEnabled(true);
            }
            action.setEnabled(false);
            TeamPlugin.log((CoreException)((Object)e));
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null) {
            this.shell = targetPart.getSite().getShell();
            this.targetPart = targetPart;
        }
    }

    protected void handle(Exception exception, String title, String message) {
        Utils.handleError((Shell)this.getShell(), (Exception)exception, (String)title, (String)message);
    }

    protected abstract boolean isEnabled() throws TeamException;

    protected Hashtable<? extends RepositoryProvider, List<IResource>> getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, ArrayList<IResource>> result = new Hashtable<RepositoryProvider, ArrayList<IResource>>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resource);
            ++n2;
        }
        return result;
    }

    protected IWorkbenchPart getTargetPart() {
        IWorkbenchPage page;
        if (this.targetPart == null && (page = TeamUIPlugin.getActivePage()) != null) {
            this.targetPart = page.getActivePart();
        }
        return this.targetPart;
    }

    protected IWorkbenchPage getTargetPage() {
        if (this.getTargetPart() == null) {
            return TeamUIPlugin.getActivePage();
        }
        return this.getTargetPart().getSite().getPage();
    }

    protected IViewPart showView(String viewId) {
        try {
            return this.getTargetPage().showView(viewId);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void init(IViewPart view) {
        if (view != null) {
            this.shell = view.getSite().getShell();
            this.targetPart = view;
        }
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.shell = window.getShell();
        window.getSelectionService().addPostSelectionListener(this.selectionListener);
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void dispose() {
        super.dispose();
        if (this.window != null) {
            this.window.getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        this.selection = null;
    }
}

