/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.notifications;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.vcs.bazaar.eclipse.core.notifications.Notification;
import org.vcs.bazaar.eclipse.core.notifications.NotificationListener;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.ReconfigureLightweightCheckoutsAction;
import org.vcs.bazaar.eclipse.ui.operations.ReconfigureLightweightCheckoutsOperation;

public class BazaarNotificationListener
implements NotificationListener {
    private static final long HOURS_BETWEEN_NOTIFICATION = 8L;

    public void message(final Notification message) {
        IPreferenceStore ps = EclipseBazaarUI.getDefault().getPreferenceStore();
        long ts = ps.getLong("notification_ts_" + message.getCategory());
        if (ts + 28800000L > System.currentTimeMillis()) {
            return;
        }
        ps.setValue("notification_ts_" + message.getCategory(), System.currentTimeMillis());
        EclipseBazaarUI.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (ReconfigureLightweightCheckoutsOperation.RUNNING.getAndSet(true)) {
                    return;
                }
                Shell lShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                switch (message.getCategory()) {
                    case LIGHTWEIGHT_CHECKOUTS: {
                        boolean convert = MessageDialog.openQuestion((Shell)lShell, (String)UITexts.Notification_lightweightCheckoutsTitle, (String)UITexts.Notification_lightweightCheckoutsQuestion);
                        if (!convert) break;
                        new ReconfigureLightweightCheckoutsAction().run(null);
                    }
                }
            }
        });
    }
}

