/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.AddCommand;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOperation {
    private final IResource[] selectedResources;
    private final boolean nestedInAnotherOperation;

    public AddOperation(IResource[] selectedResources, boolean nestedInAnotherOperation) {
        this.selectedResources = selectedResources;
        this.nestedInAnotherOperation = nestedInAnotherOperation;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                Hashtable<BazaarTeamProvider, List<IResource>> map = this.getProviderMapping(this.selectedResources);
                Set keySet = map.keySet();
                monitor.beginTask("", keySet.size() * 1000);
                monitor.setTaskName(CoreTexts.AddCommand_adding);
                for (BazaarTeamProvider provider : keySet) {
                    List resources = (List)map.get(provider);
                    AddCommand op = new AddCommand(provider.getBzrWorkspaceRoot(), resources);
                    if (this.nestedInAnotherOperation) {
                        op.execute(monitor);
                        monitor.worked(1000);
                        continue;
                    }
                    op.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                }
            }
            catch (CoreException e) {
                EclipseBazaarUI.log(e.getMessage(), e);
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected Hashtable<BazaarTeamProvider, List<IResource>> getProviderMapping(IResource[] resources) {
        Hashtable<BazaarTeamProvider, List<IResource>> result = new Hashtable<BazaarTeamProvider, List<IResource>>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            BazaarTeamProvider provider = (BazaarTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)EclipseBazaarCore.getProviderID());
            List<IResource> list = result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resource);
            ++n2;
        }
        return result;
    }
}

