/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.operations;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.ui.TeamOperation;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.ICheckoutOptions;
import org.vcs.bazaar.eclipse.core.commands.BranchCommand;
import org.vcs.bazaar.eclipse.core.commands.CheckoutCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.ui.branch.BranchLocationManager;

public class CheckoutBazaarProjectOperation
extends TeamOperation {
    public static int TYPE_CHECKOUT = 1;
    public static int TYPE_LIGHTWEIGHT = 2;
    public static int TYPE_BRANCH = 3;
    IBzrBranch remoteBranch;
    File projectLocation;
    int type;
    String revision;

    public CheckoutBazaarProjectOperation(IRunnableContext context, IBzrBranch remoteBranch, int type, String revision) throws IOException {
        super(context);
        this.remoteBranch = remoteBranch;
        this.projectLocation = ResourceUtil.createTempFile((String)"bzreclipse", null);
        this.projectLocation.delete();
        this.type = type;
        this.revision = revision;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            BranchCommand op;
            if (this.type == TYPE_BRANCH) {
                op = new BranchCommand(this.remoteBranch, this.projectLocation, this.revision, new Option[0]);
            } else {
                ArrayList<Object> options = new ArrayList<Object>(0);
                if (this.type == TYPE_LIGHTWEIGHT) {
                    options.add(ICheckoutOptions.LIGHTWEIGHT);
                }
                if (this.revision != null && this.revision.trim().length() > 0) {
                    String s = BazaarRevision.getRevision((BazaarRevision.Prefix)BazaarRevision.Prefix.REVNO, (String)this.revision).toString();
                    options.add(ICheckoutOptions.REVISION.setArgument(s));
                }
                op = new CheckoutCommand(this.remoteBranch, this.projectLocation, options.toArray(new Option[0]));
            }
            op.run(monitor);
            BranchLocationManager.saveBranchLocation(this.remoteBranch.getBranchLocation().toString());
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public String getProjectLocation() {
        return this.projectLocation.getAbsolutePath();
    }
}

