/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.operations;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.ui.TeamOperation;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProviderType;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;

public class CreateBazaarProjectOperation
extends TeamOperation {
    String projectName;
    File projectLocation;
    File tempFolder;
    IProject project;
    List<File> projectsToImport;
    boolean importExisting;

    public CreateBazaarProjectOperation(IRunnableContext context, File tempFolder, IProject project) {
        super(context);
        this.tempFolder = tempFolder;
        this.project = project;
    }

    public CreateBazaarProjectOperation(IRunnableContext context, File tempFolder, String projectName, String projectLocation, boolean importExisting) {
        super(context);
        this.tempFolder = tempFolder;
        this.projectName = projectName;
        this.projectLocation = new File(projectLocation);
        this.importExisting = importExisting;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                if (this.project != null) {
                    this.mergeWithExistingProject(monitor);
                } else {
                    this.createProjects(monitor);
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            ResourceUtil.deleteRecursively((File)this.tempFolder);
        }
    }

    private void createProjects(IProgressMonitor monitor) throws CoreException, IOException {
        ResourceUtil.move((File)this.tempFolder, (File)this.projectLocation);
        if (this.importExisting) {
            List projDirs = ResourceUtil.findProjects((File)this.projectLocation);
            for (File projDir : projDirs) {
                this.createProject(projDir, monitor);
            }
        } else {
            File dotProj = new File(this.projectLocation, ".project");
            if (dotProj.exists()) {
                dotProj.delete();
            }
            this.createProject(this.projectLocation, monitor);
        }
    }

    private void createProject(File projDir, IProgressMonitor monitor) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        Path projPath = new Path(projDir.toString());
        IPath parentPath = projPath.removeLastSegments(1);
        IProject projectHandle = null;
        if (parentPath.equals((Object)ws.getRoot().getLocation()) && projPath.lastSegment().equals(this.projectName)) {
            projectHandle = ws.getRoot().getProject(this.projectName);
            projectHandle.create(monitor);
        } else {
            String newProjectName = String.valueOf(this.projectName) + "-" + projPath.lastSegment();
            projectHandle = ws.getRoot().getProject(newProjectName);
            IProjectDescription projDesc = ws.newProjectDescription(newProjectName);
            projDesc.setLocation((IPath)projPath);
            projectHandle.create(projDesc, monitor);
        }
        projectHandle.open(monitor);
        BazaarTeamProviderType.registerProject((IProject)projectHandle);
    }

    private void mergeWithExistingProject(IProgressMonitor monitor) throws CoreException, IOException {
        this.mergeFolders(this.tempFolder, this.project.getLocation().toFile());
        this.project.refreshLocal(2, monitor);
    }

    private void mergeFolders(File source, File destination) throws IOException {
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                File target;
                File f;
                block3: {
                    block4: {
                        f = fileArray[n2];
                        target = new File(destination, f.getName());
                        if (!target.exists()) break block3;
                        if (!target.isDirectory() || !f.isDirectory()) break block4;
                        this.mergeFolders(f, target);
                        break block5;
                    }
                    if (f.getName().equals(".project")) break block5;
                    target.delete();
                }
                ResourceUtil.move((File)f, (File)target);
            }
            ++n2;
        }
    }
}

