/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.CreatePatchCommand;
import org.vcs.bazaar.eclipse.core.commands.RemoveCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.operations.AddOperation;
import org.vcs.bazaar.eclipse.ui.operations.BzrOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePatchOperation
extends BzrOperation {
    private final List<IBzrResourceStatus> resources;
    private final IBazaarRevisionSpec revision;
    private final Option[] options;
    private String patchContent;

    public CreatePatchOperation(IRunnableContext context, List<IBzrResourceStatus> list, IBazaarRevisionSpec revision, Option[] options) {
        super(context);
        this.resources = list;
        this.revision = revision;
        this.options = options;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        List<IResource> filesToAdd = WorkbenchAction.getUnknownResources(this.resources);
        if (!filesToAdd.isEmpty()) {
            new AddOperation(filesToAdd.toArray(new IResource[0]), true).run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
        }
        try {
            try {
                CreatePatchCommand cmd = new CreatePatchCommand(WorkbenchAction.getResources(this.resources), this.revision, this.options);
                cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                this.patchContent = cmd.getPatchContent();
            }
            catch (BazaarException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            RemoveCommand rcmd = new RemoveCommand(BzrWorkspaceRoot.getBzrResourcesFor((IResource[])filesToAdd.toArray(new IResource[0])));
            try {
                rcmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
            }
            catch (BazaarException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    public String getPatchContent() {
        return this.patchContent;
    }
}

