/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.PushCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.ProjectBranch;
import org.vcs.bazaar.eclipse.ui.operations.BzrOperation;

public class PushOperation
extends BzrOperation {
    private IBzrBranch branch;
    private BranchLocation location;
    private boolean remember;
    private boolean overwrite;
    private boolean useExsitingDir;

    public PushOperation(IBzrBranch branch, BranchLocation location, boolean remember, boolean overwrite, boolean useExsitingDir) {
        this(null, branch, location, remember, overwrite, useExsitingDir);
    }

    public PushOperation(IWorkbenchPart part, IBzrBranch branch, BranchLocation location, boolean remember, boolean overwrite, boolean useExsitingDir) {
        super(part);
        this.branch = branch;
        this.location = location;
        this.remember = remember;
        this.overwrite = overwrite;
        this.useExsitingDir = useExsitingDir;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(CoreTexts.bind((String)CoreTexts.PushCommand_taskName, (Object)this.location.toString()), 1000);
                PushCommand cmd = new PushCommand(this.branch, this.location);
                cmd.setRemember(this.remember);
                cmd.setOverwrite(this.overwrite);
                cmd.setUseExsitingDir(this.useExsitingDir);
                cmd.run(monitor);
                if (this.branch instanceof ProjectBranch) {
                    ((ProjectBranch)this.branch).setDirty(true);
                }
            }
            catch (BazaarException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getJobName() {
        return "Pushing " + this.branch.getName();
    }

    protected boolean canRunAsJob() {
        return true;
    }
}

