/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.SendCommand;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.ProjectBranch;
import org.vcs.bazaar.eclipse.ui.operations.BzrOperation;

public class SendOperation
extends BzrOperation {
    private final IBzrLocalResource resource;
    private Option[] options;
    private BranchLocation branchLocation;

    public SendOperation(IWorkbenchPart part, IBzrLocalResource bzrResource, Option[] options, BranchLocation branchLocation) {
        super(part);
        this.resource = bzrResource;
        this.options = options;
        this.branchLocation = branchLocation;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(CoreTexts.bind((String)CoreTexts.SendCommand_send, (Object)this.branchLocation.toString()), 1000);
                SendCommand cmd = new SendCommand(this.resource, this.options, this.branchLocation);
                cmd.run(monitor);
                if (this.resource.getBranch() instanceof ProjectBranch) {
                    ((ProjectBranch)this.resource.getBranch()).setDirty(true);
                }
            }
            catch (BazaarException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getJobName() {
        return "Sending " + this.resource.getName();
    }

    protected boolean canRunAsJob() {
        return true;
    }
}

