/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.preferences;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.ClientProperties;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.UITexts;

public class BazaarPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FileFieldEditor executable;
    private BooleanFieldEditor overwriteEmail;
    private StringFieldEditor email;
    private StringFieldEditor clientValue;
    private IntegerFieldEditor xmlrpcPort;
    private BooleanFieldEditor disableLogs;

    public BazaarPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), EclipseBazaarCore.getPluginId()));
        this.setDescription(UITexts.BazaarPreferencesPage_description);
    }

    public void init(IWorkbench workbench) {
    }

    public void createFieldEditors() {
        this.executable = new FileFieldEditor(BazaarPreference.EXECUTABLE.name(), UITexts.BazaarPreferencesPage_executable, this.getFieldEditorParent());
        this.overwriteEmail = new BooleanFieldEditor("pref_overwrite_email", UITexts.BazaarPreferencesPage_overwrite_userid, this.getFieldEditorParent());
        this.email = new StringFieldEditor(BazaarPreference.BZR_EMAIL.name(), UITexts.BazaarPreferencesPage_userid, this.getFieldEditorParent());
        this.addField((FieldEditor)this.executable);
        this.addField((FieldEditor)this.overwriteEmail);
        this.addField((FieldEditor)this.email);
        this.createClientTypeControl();
        this.createXmlRpClientConfigControl();
        this.disableLogs = new BooleanFieldEditor("disable_logs", UITexts.BazaarPreferencesPage_disable_logs, this.getFieldEditorParent());
        this.addField((FieldEditor)this.disableLogs);
        this.addField((FieldEditor)new BooleanFieldEditor("ignore_ssl_errors", UITexts.BazaarPreferencesPage_ignore_ssl_errors, this.getFieldEditorParent()));
        this.executable.getTextControl(this.getFieldEditorParent()).setEditable(false);
        this.email.getTextControl(this.getFieldEditorParent()).setEnabled(this.getPreferenceStore().getBoolean("pref_overwrite_email"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.overwriteEmail) {
            this.email.getTextControl(this.getFieldEditorParent()).setEnabled(((Boolean)event.getNewValue()).booleanValue());
        }
    }

    private void createClientTypeControl() {
        this.clientValue = new StringFieldEditor("ClientValue", UITexts.BazaarPreferencesPage_client_type, this.getFieldEditorParent());
        this.addField((FieldEditor)this.clientValue);
        this.clientValue.getTextControl(this.getFieldEditorParent()).setEnabled(false);
        this.setClientTypeLabel();
    }

    private void createXmlRpClientConfigControl() {
        this.xmlrpcPort = new IntegerFieldEditor(BazaarPreference.BZR_XMLRPC_PORT.name(), UITexts.BazaarPreferencesPage_xmlrpc_port, this.getFieldEditorParent(), 5);
        this.addField((FieldEditor)this.xmlrpcPort);
    }

    private void setClientTypeLabel() {
        try {
            this.clientValue.setStringValue(BazaarClientFactory.getPreferredClientType());
        }
        catch (BazaarClientException e1) {
            this.clientValue.setStringValue(e1.getMessage());
        }
    }

    protected void initialize() {
        super.initialize();
        this.checkValidClient();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.email.getTextControl(this.getFieldEditorParent()).setEnabled(this.overwriteEmail.getBooleanValue());
    }

    public boolean performOk() {
        if (super.performOk()) {
            return this.checkValidClient();
        }
        return false;
    }

    private boolean checkValidClient() {
        ClientProperties properties = EclipseBazaarCore.getDefault().getClientProperties(this.executable.getStringValue(), this.overwriteEmail.getBooleanValue() ? this.email.getStringValue() : null, this.xmlrpcPort.getStringValue(), this.disableLogs.getBooleanValue());
        try {
            EclipseBazaarCore.getDefault().checkClient(properties);
            this.setMessage(null, 3);
            return true;
        }
        catch (BazaarException e) {
            this.setMessage(e.getStatus().getMessage(), 3);
            return false;
        }
        finally {
            this.setClientTypeLabel();
        }
    }
}

