/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.UIUtils;
import org.vcs.bazaar.eclipse.ui.dialogs.CommitMessageHistory;
import org.vcs.bazaar.eclipse.ui.preferences.TemplateEditorDialog;

public class TemplateEditorComponent
extends FieldEditor
implements ISelectionChangedListener {
    private List list;
    private ListViewer viewer;
    private Composite buttonBox;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Composite previewBox;
    private Text preview;
    private Shell shell;
    private int previewHeight;

    public TemplateEditorComponent(Shell shell, Composite parent, int previewHeight) {
        this.shell = shell;
        this.previewHeight = previewHeight;
        this.createControl(parent);
        this.getLabelControl().setText(UITexts.TemplateEditorComponent_label);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.getLabelControl().getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        List list = this.getListControl(parent);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = numColumns - 1;
        list.setLayoutData((Object)gd);
        Composite buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        buttonBox.setLayoutData((Object)gd);
        Composite previewBox = this.getPreviewBoxControl(parent);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = numColumns;
        previewBox.setLayoutData((Object)gd);
    }

    public List getListControl(Composite parent) {
        if (this.viewer == null) {
            this.createList(parent);
        }
        return this.viewer.getList();
    }

    private void createList(Composite parent) {
        this.viewer = new ListViewer(parent);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return UIUtils.getFirstLine((String)element);
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String template1 = UIUtils.getFirstLine((String)e1);
                String template2 = UIUtils.getFirstLine((String)e2);
                return template1.compareToIgnoreCase(template2);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TemplateEditorComponent.this.editPressed();
            }
        });
        this.list = this.viewer.getList();
        this.list.setFont(parent.getFont());
        this.list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TemplateEditorComponent.this.viewer = null;
            }
        });
    }

    private Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.createButtonBox(parent);
        }
        return this.buttonBox;
    }

    private void createButtonBox(Composite parent) {
        this.buttonBox = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.buttonBox.setLayout((Layout)layout);
        this.createButtons(this.buttonBox);
        this.buttonBox.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TemplateEditorComponent.this.addButton = null;
                TemplateEditorComponent.this.editButton = null;
                TemplateEditorComponent.this.removeButton = null;
                TemplateEditorComponent.this.buttonBox = null;
            }
        });
    }

    private Composite getPreviewBoxControl(Composite parent) {
        if (this.previewBox == null) {
            this.createPreviewBox(parent);
        }
        return this.previewBox;
    }

    private void createPreviewBox(Composite parent) {
        this.previewBox = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.previewBox.setLayout((Layout)layout);
        Label previewLabel = new Label(this.previewBox, 0);
        previewLabel.setText(UITexts.TemplateEditorComponent_preview);
        this.preview = new Text(this.previewBox, 2570);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = this.previewHeight;
        this.preview.setLayoutData((Object)gd);
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, UITexts.TemplateEditorComponent_new);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorComponent.this.addPressed();
            }
        });
        this.editButton = this.createPushButton(box, UITexts.TemplateEditorComponent_edit);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorComponent.this.editPressed();
            }
        });
        this.removeButton = this.createPushButton(box, UITexts.TemplateEditorComponent_remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorComponent.this.removePressed();
            }
        });
    }

    private Button createPushButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return button;
    }

    private void editPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            String template = (String)selection.getFirstElement();
            this.editTemplate(template);
        }
    }

    private void addPressed() {
        this.editTemplate(null);
    }

    private void editTemplate(String template) {
        TemplateEditorDialog dialog = new TemplateEditorDialog(this.shell, template);
        if (dialog.open() == 0 && !dialog.getTemplate().isEmpty()) {
            if (template != null) {
                this.viewer.remove((Object)template);
            }
            this.viewer.add((Object)dialog.getTemplate());
        }
    }

    private void removePressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.viewer.remove(selection.toArray());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.removeButton.setEnabled(selection.size() > 0);
        this.editButton.setEnabled(selection.size() == 1);
        this.preview.setText(selection.size() == 1 ? (String)selection.getFirstElement() : "");
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doLoad() {
        for (String template : CommitMessageHistory.getTemplates()) {
            this.viewer.add((Object)template);
        }
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        int numTemplates = this.viewer.getList().getItemCount();
        ArrayList<String> templates = new ArrayList<String>();
        int i = 0;
        while (i < numTemplates) {
            templates.add((String)this.viewer.getElementAt(i));
            ++i;
        }
        CommitMessageHistory.saveTemplates(templates);
    }
}

