/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.eclipse.core.commands.InfoCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;

public class BazaarPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IBazaarInfo info = null;
    private Text layout;
    private Text controlDirFormat;
    private Composite formats;
    private Text branchFormat;
    private Text controlFormat;
    private Text repositoryFormat;
    private Text workingTreeFormat;
    private Composite locations;
    private Text lightCheckoutRoot;
    private Text repositoryCheckoutRoot;
    private Text checkoutRoot;
    private Text checkoutOfBranch;
    private Text sharedRepository;
    private Text repository;
    private Text repositoryBranch;
    private Text branchRoot;
    private Text boundToBranch;
    private Composite relatedBranches;
    private Text publicBranch;
    private Text pushBranch;
    private Text parentBranch;
    private Text submitBranch;
    private Composite workingTreeStats;
    private Text added;
    private Text ignored;
    private Text modified;
    private Text removed;
    private Text renamed;
    private Text unchanged;
    private Text unknown;
    private Text versionedSubdirectories;
    private Composite branchHistory;
    private Text branchRevisions;
    private Text committers;
    private Text daysOld;
    private Text firstRevisionDate;
    private Text latestRevisionDate;
    private Composite repositoryStats;
    private Text repositoryRevisions;
    private Text repositorySize;

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label label = new Label(composite, 0);
        label.setText("Layout: ");
        this.layout = new Text(composite, 12);
        label = new Label(composite, 0);
        label.setText("Control directory format: ");
        this.controlDirFormat = new Text(composite, 12);
        if (this.info == null) {
            return;
        }
        this.layout.setText(this.info.getLayout());
        StringBuilder sb = new StringBuilder();
        String[] formats = this.info.getFormats();
        int idx = 0;
        while (idx < formats.length) {
            sb.append(formats[idx]);
            if (idx + 1 < formats.length) {
                sb.append(" or ");
            }
            ++idx;
        }
        this.controlDirFormat.setText(sb.toString());
        if (this.info.getRelatedBranches() == null) {
            return;
        }
        label = new Label(composite, 0);
        label.setText("Related branches: ");
        this.relatedBranches = this.createDefaultComposite(composite);
        if (this.info.getRelatedBranches().getParentBranch() != null) {
            label = new Label(this.relatedBranches, 0);
            label.setText("Parent Branch: ");
            this.parentBranch = new Text(this.relatedBranches, 12);
            this.parentBranch.setText(this.info.getRelatedBranches().getParentBranch());
        }
        if (this.info.getRelatedBranches().getPushBranch() != null) {
            label = new Label(this.relatedBranches, 0);
            label.setText("Push branch: ");
            this.pushBranch = new Text(this.relatedBranches, 12);
            this.pushBranch.setText(this.info.getRelatedBranches().getPushBranch());
        }
        if (this.info.getRelatedBranches().getPublicBranch() != null) {
            label = new Label(this.relatedBranches, 0);
            label.setText("Public branch: ");
            this.publicBranch = new Text(this.relatedBranches, 12);
            this.publicBranch.setText(this.info.getRelatedBranches().getPublicBranch());
        }
        if (this.info.getRelatedBranches().getSubmitBranch() != null) {
            label = new Label(this.relatedBranches, 0);
            label.setText("Submit branch: ");
            this.submitBranch = new Text(this.relatedBranches, 12);
            this.submitBranch.setText(this.info.getRelatedBranches().getSubmitBranch());
        }
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label label = new Label(composite, 0);
        label.setText("Formats: ");
        this.formats = this.createDefaultComposite(composite);
        label = new Label(this.formats, 0);
        label.setText("Branch format: ");
        this.branchFormat = new Text(this.formats, 12);
        label = new Label(this.formats, 0);
        label.setText("Control format: ");
        this.controlFormat = new Text(this.formats, 12);
        label = new Label(this.formats, 0);
        label.setText("Repository format: ");
        this.repositoryFormat = new Text(this.formats, 12);
        label = new Label(this.formats, 0);
        label.setText("Working tree format: ");
        this.workingTreeFormat = new Text(this.formats, 12);
        if (this.info == null) {
            return;
        }
        this.branchFormat.setText(this.info.getBranchFormat() == null ? "" : this.info.getBranchFormat());
        this.controlFormat.setText(this.info.getControlFormat() == null ? "" : this.info.getControlFormat());
        this.repositoryFormat.setText(this.info.getRepositoryFormat() == null ? "" : this.info.getRepositoryFormat());
        this.workingTreeFormat.setText(this.info.getWorkingTreeFormat() == null ? "" : this.info.getWorkingTreeFormat());
        this.createLocations(composite);
        this.createWorkingTreeStats(composite);
        this.createBranchHistory(composite);
        if (this.info.getRepositoryStats() == null) {
            return;
        }
        label = new Label(composite, 0);
        label.setText("Repository");
        this.repositoryStats = this.createDefaultComposite(composite);
        if (this.info.getRepositoryStats().getRevisionCount() != null) {
            this.repositoryRevisions = new Text(this.repositoryStats, 72);
            this.repositoryRevisions.setText(this.info.getRepositoryStats().getRevisionCount().toString());
            label = new Label(this.repositoryStats, 0);
            label.setText("revisions");
        }
        if (this.info.getRepositoryStats().getSize() != null) {
            this.repositorySize = new Text(this.repositoryStats, 72);
            this.repositorySize.setText(this.info.getRepositoryStats().getSize().toString());
            label = new Label(this.repositoryStats, 0);
            label.setText("KiB");
        }
    }

    private void createWorkingTreeStats(Composite parent) {
        if (this.info.getWorkingTreeStats() == null) {
            return;
        }
        Label label = new Label(parent, 0);
        label.setText("In the working tree");
        this.workingTreeStats = this.createDefaultComposite(parent);
        if (this.info.getWorkingTreeStats().getUnchanged() != null) {
            this.unchanged = new Text(this.workingTreeStats, 72);
            this.unchanged.setText(this.info.getWorkingTreeStats().getUnchanged().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("unchanged");
        }
        if (this.info.getWorkingTreeStats().getModified() != null) {
            this.modified = new Text(this.workingTreeStats, 72);
            this.modified.setText(this.info.getWorkingTreeStats().getModified().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("modified");
        }
        if (this.info.getWorkingTreeStats().getAdded() != null) {
            this.added = new Text(this.workingTreeStats, 72);
            this.added.setText(this.info.getWorkingTreeStats().getAdded().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("added");
        }
        if (this.info.getWorkingTreeStats().getRemoved() != null) {
            this.removed = new Text(this.workingTreeStats, 72);
            this.removed.setText(this.info.getWorkingTreeStats().getRemoved().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("removed");
        }
        if (this.info.getWorkingTreeStats().getRenamed() != null) {
            this.renamed = new Text(this.workingTreeStats, 72);
            this.renamed.setText(this.info.getWorkingTreeStats().getRenamed().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("renamed");
        }
        if (this.info.getWorkingTreeStats().getUnknown() != null) {
            this.unknown = new Text(this.workingTreeStats, 72);
            this.unknown.setText(this.info.getWorkingTreeStats().getUnknown().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("unknown");
        }
        if (this.info.getWorkingTreeStats().getIgnored() != null) {
            this.ignored = new Text(this.workingTreeStats, 72);
            this.ignored.setText(this.info.getWorkingTreeStats().getIgnored().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("ignored");
        }
        if (this.info.getWorkingTreeStats().getVersionedSubdirectories() != null) {
            this.versionedSubdirectories = new Text(this.workingTreeStats, 72);
            this.versionedSubdirectories.setText(this.info.getWorkingTreeStats().getVersionedSubdirectories().toString());
            label = new Label(this.workingTreeStats, 0);
            label.setText("versioned subdirectories");
        }
    }

    private void createLocations(Composite parent) {
        if (this.info.getLocations() == null) {
            return;
        }
        Label label = new Label(parent, 0);
        label.setText("Locations: ");
        this.locations = this.createDefaultComposite(parent);
        if (this.info.getLocations().getLightCheckoutRoot() != null) {
            label = new Label(this.locations, 0);
            label.setText("Light checkout root: ");
            this.lightCheckoutRoot = new Text(this.locations, 12);
            this.lightCheckoutRoot.setText(this.info.getLocations().getLightCheckoutRoot());
        }
        if (this.info.getLocations().getRepositoryCheckoutRoot() != null) {
            label = new Label(this.locations, 0);
            label.setText("Repository checkout root: ");
            this.repositoryCheckoutRoot = new Text(this.locations, 12);
            this.repositoryCheckoutRoot.setText(this.info.getLocations().getRepositoryCheckoutRoot());
        }
        if (this.info.getLocations().getCheckoutRoot() != null) {
            label = new Label(this.locations, 0);
            label.setText("Checkout root: ");
            this.checkoutRoot = new Text(this.locations, 12);
            this.checkoutRoot.setText(this.info.getLocations().getCheckoutRoot());
        }
        if (this.info.getLocations().getCheckoutOfBranch() != null) {
            label = new Label(this.locations, 0);
            label.setText("Checkout of branch: ");
            this.checkoutOfBranch = new Text(this.locations, 12);
            this.checkoutOfBranch.setText(this.info.getLocations().getCheckoutOfBranch());
        }
        if (this.info.getLocations().getSharedRepository() != null) {
            label = new Label(this.locations, 0);
            label.setText("Shared repository: ");
            this.sharedRepository = new Text(this.locations, 12);
            this.sharedRepository.setText(this.info.getLocations().getSharedRepository());
        }
        if (this.info.getLocations().getRepository() != null) {
            label = new Label(this.locations, 0);
            label.setText("Repository: ");
            this.repository = new Text(this.locations, 12);
            this.repository.setText(this.info.getLocations().getRepository());
        }
        if (this.info.getLocations().getRepositoryBranch() != null) {
            label = new Label(this.locations, 0);
            label.setText("Repository branch: ");
            this.repositoryBranch = new Text(this.locations, 12);
            this.repositoryBranch.setText(this.info.getLocations().getRepositoryBranch());
        }
        if (this.info.getLocations().getBranchRoot() != null) {
            label = new Label(this.locations, 0);
            label.setText("Branch root: ");
            this.branchRoot = new Text(this.locations, 12);
            this.branchRoot.setText(this.info.getLocations().getBranchRoot());
        }
        if (this.info.getLocations().getBoundToBranch() != null) {
            label = new Label(this.locations, 0);
            label.setText("Bound to branch: ");
            this.boundToBranch = new Text(this.locations, 12);
            this.boundToBranch.setText(this.info.getLocations().getBoundToBranch());
        }
    }

    private void createBranchHistory(Composite parent) {
        if (this.info.getBranchHistory() == null) {
            return;
        }
        Label label = new Label(parent, 0);
        label.setText("Branch history: ");
        this.branchHistory = this.createDefaultComposite(parent);
        if (this.info.getBranchHistory().getRevisions() != null) {
            label = new Label(this.branchHistory, 0);
            label.setText("Revisions: ");
            this.branchRevisions = new Text(this.branchHistory, 72);
            this.branchRevisions.setText(this.info.getBranchHistory().getRevisions().toString());
        }
        if (this.info.getBranchHistory().getCommitters() != null) {
            label = new Label(this.branchHistory, 0);
            label.setText("Committers: ");
            this.committers = new Text(this.branchHistory, 72);
            this.committers.setText(this.info.getBranchHistory().getCommitters().toString());
        }
        if (this.info.getBranchHistory().getDaysOld() != null) {
            label = new Label(this.branchHistory, 0);
            label.setText("Days old: ");
            this.daysOld = new Text(this.branchHistory, 72);
            this.daysOld.setText(this.info.getBranchHistory().getDaysOld().toString());
        }
        if (this.info.getBranchHistory().getFirstRevisionDate() != null) {
            label = new Label(this.branchHistory, 0);
            label.setText("First revision date: ");
            this.firstRevisionDate = new Text(this.branchHistory, 12);
            this.firstRevisionDate.setText(this.info.getBranchHistory().getFirstRevisionDate().toString());
        }
        if (this.info.getBranchHistory().getLatestRevisionDate() != null) {
            label = new Label(this.branchHistory, 0);
            label.setText("Latest revision date: ");
            this.latestRevisionDate = new Text(this.branchHistory, 12);
            this.latestRevisionDate.setText(this.info.getBranchHistory().getLatestRevisionDate().toString());
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        composite.setLayoutData((Object)data);
        this.loadInfo();
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void loadInfo() {
        IResource resource = (IResource)this.getElement();
        try {
            InfoCommand cmd = new InfoCommand((IBzrBranch)BranchFactory.findOrCreateFor((IProject)resource.getProject()));
            cmd.run((IProgressMonitor)new NullProgressMonitor());
            this.info = cmd.getInfo();
        }
        catch (BazaarException bazaarException) {
            try {
                InfoCommand cmd = new InfoCommand((IBzrBranch)BranchFactory.findOrCreateFor((IProject)resource.getProject()), false);
                cmd.run((IProgressMonitor)new NullProgressMonitor());
                this.info = cmd.getInfo();
            }
            catch (BazaarException e1) {
                EclipseBazaarUI.log((CoreException)((Object)e1));
            }
        }
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        return true;
    }
}

