/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.repository.tree;

import java.util.ArrayList;
import java.util.List;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryRemotesNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTagsNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTreeNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTreeNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryBranchNode
extends RepositoryTreeNode {
    private final IBzrBranch branch;
    private String name;
    private boolean project;

    public RepositoryBranchNode(IBzrBranch branch) {
        super(null, RepositoryTreeNodeType.BRANCH);
        this.branch = branch;
    }

    public IBzrBranch getBranch() {
        return this.branch;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.branch.getNick();
            }
            catch (Exception exception) {
                this.name = "Error!";
            }
        }
        return this.name;
    }

    @Override
    public String getLocation() {
        return this.branch.getBranchLocation().toString();
    }

    public boolean isProject() {
        return this.project;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public List<RepositoryTreeNode> getChildren() {
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        nodes.add(new RepositoryRemotesNode(this));
        nodes.add(new RepositoryTagsNode(this));
        return nodes;
    }
}

