/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.repository.tree;

import java.util.ArrayList;
import java.util.List;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.internal.core.model.LocalBranch;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryBranchNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryRemoteNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTreeNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTreeNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryRemotesNode
extends RepositoryTreeNode {
    private final IBzrBranch branch;

    public RepositoryRemotesNode(RepositoryBranchNode branch) {
        super(branch, RepositoryTreeNodeType.REMOTES);
        this.branch = branch.getBranch();
    }

    @Override
    public String getName() {
        return "Remotes";
    }

    private void addBranch(String name, String location, List<RepositoryTreeNode> nodes) {
        IBzrBranch branch;
        if (location != null && (branch = BranchFactory.findOrCreateFor((String)location)) != null && !branch.isLocal()) {
            nodes.add(new RepositoryRemoteNode(this, name, branch));
        }
    }

    @Override
    public List<RepositoryTreeNode> getChildren() {
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        if (this.branch instanceof LocalBranch) {
            IBazaarInfo info = ((LocalBranch)this.branch).getInfo();
            IBazaarInfo.RelatedBranches branches = info.getRelatedBranches();
            if (branches != null) {
                this.addBranch("Parent", branches.getParentBranch(), nodes);
                this.addBranch("Public", branches.getPublicBranch(), nodes);
                this.addBranch("Push", branches.getPushBranch(), nodes);
                this.addBranch("Submit", branches.getSubmitBranch(), nodes);
            }
            if (info.getLocations() != null) {
                this.addBranch("Bound to", info.getLocations().getBoundToBranch(), nodes);
                this.addBranch("Checkout of", info.getLocations().getCheckoutOfBranch(), nodes);
            }
        }
        return nodes;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }
}

