/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.repository.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarTag;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryBranchNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTagNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTreeNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryTreeNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTagsNode
extends RepositoryTreeNode {
    public RepositoryTagsNode(RepositoryBranchNode parent) {
        super(parent, RepositoryTreeNodeType.TAGS);
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    protected List<IBazaarTag> getTags() {
        IBzrBranch branch = ((RepositoryBranchNode)this.parent).getBranch();
        try {
            IBazaarClient client = EclipseBazaarCore.getDefault().createClient();
            client.setWorkDir(branch.getFile());
            return client.tags(new Option[0]);
        }
        catch (BazaarException e) {
            throw BazaarException.makeUnChecked((CoreException)((Object)e));
        }
        catch (BazaarClientException e) {
            throw BazaarClientException.makeUnChecked((Exception)((Object)e));
        }
    }

    @Override
    public List<RepositoryTreeNode> getChildren() {
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        List<IBazaarTag> tags = this.getTags();
        for (IBazaarTag tag : tags) {
            RepositoryTagNode node = new RepositoryTagNode((RepositoryTreeNode)this, tag);
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public String getName() {
        return "Tags";
    }
}

