/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.repository.tree.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.history.BazaarHistoryPageInput;
import org.vcs.bazaar.eclipse.ui.repository.tree.RepositoryBranchNode;
import org.vcs.bazaar.eclipse.ui.repository.tree.command.RepositoriesViewCommandHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryCommand
extends RepositoriesViewCommandHandler<RepositoryBranchNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        UIJob job = this.createJob(event);
        job.setUser(true);
        job.setPriority(40);
        job.schedule();
        return null;
    }

    private UIJob createJob(final ExecutionEvent event) {
        return new UIJob(this.getShell(event).getDisplay(), "Fetching revision history"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask("fetching...", 100);
                try {
                    List node = HistoryCommand.this.getSelectedNodes(event);
                    monitor.subTask("fetching resource revisions");
                    monitor.worked(20);
                    TeamUI.getHistoryView().showHistoryFor((Object)new BazaarHistoryPageInput((IBzrResource)((RepositoryBranchNode)((Object)node.get(0))).getBranch(), null));
                    IStatus iStatus = BzrJobStatus.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    EclipseBazaarUI.log(e.getMessage(), e);
                    IStatus iStatus = UIJob.errorStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
    }
}

