/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.synchronize;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarResourceVariantTreeSubscriber;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSubscriberMergeContext;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSynchronizeData;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.synchronize.BazaarSynchronizeActionContributor;

public class BazaarModelSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String ID = "org.vcs.bazaar.eclipse.ui.synchronize.BazaarModelSynchronizeParticipant";
    private static final String DATA_NODE_KEY = "bazaarSynchronizeData";
    private static final String RESOURCE_KEY = "resource";
    private static final String BRANCH_KEY = "branch";
    private static final String PATH_KEY = "path";
    private static final String SYNCHRONIZATION_DATA = "BZR_SYNCHRONIZE_DATA";
    private BazaarSynchronizeData syncData;

    public BazaarModelSynchronizeParticipant() {
    }

    public BazaarModelSynchronizeParticipant(BazaarSubscriberMergeContext context) {
        super((SynchronizationContext)context);
        this.syncData = context.getSyncData();
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            EclipseBazaarUI.log(e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        try {
            try {
                IMemento syncDataNode = memento.getChild(DATA_NODE_KEY);
                if (syncDataNode != null) {
                    IMemento[] paths = syncDataNode.getChildren(RESOURCE_KEY);
                    BranchLocation branchLocation = new BranchLocation(syncDataNode.getString(BRANCH_KEY));
                    HashSet<IContainer> resources = new HashSet<IContainer>();
                    IMemento[] iMementoArray = paths;
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento path = iMementoArray[n2];
                        IContainer resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(path.getString(PATH_KEY)));
                        resources.add(resource);
                        ++n2;
                    }
                    this.syncData = new BazaarSynchronizeData(resources.toArray(new IResource[resources.size()]), branchLocation);
                }
            }
            catch (BazaarClientException e) {
                throw new PartInitException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            super.init(secondaryId, memento);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.syncData != null) {
            IMemento child = memento.createChild(DATA_NODE_KEY);
            child.putString(BRANCH_KEY, this.syncData.getRemoteLocation().toString());
            IResource[] resources = this.syncData.getResources();
            if (resources != null) {
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    String path = resource.getLocation().toPortableString();
                    child.createChild(RESOURCE_KEY).putString(PATH_KEY, path);
                    ++n2;
                }
            }
        }
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) throws CoreException {
        if (this.syncData != null) {
            BazaarResourceVariantTreeSubscriber subscriber = new BazaarResourceVariantTreeSubscriber(this.syncData);
            subscriber.init((IProgressMonitor)new NullProgressMonitor());
            return new BazaarSubscriberMergeContext((Subscriber)subscriber, manager, this.syncData);
        }
        return super.restoreContext(manager);
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty(SYNCHRONIZATION_DATA, (Object)this.syncData);
        super.initializeConfiguration(configuration);
        configuration.addActionContribution((SynchronizePageActionGroup)new BazaarSynchronizeActionContributor());
    }
}

