/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.team;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;

public class BazaarUtilities {
    public static String getBzrExecutable() {
        Preferences prefs = EclipseBazaarCore.getDefault().getPluginPreferences();
        return prefs.getString(BazaarPreference.EXECUTABLE.name());
    }

    public static String getBzrExecutable(boolean configureIfMissing) {
        if (EclipseBazaarCore.getDefault().isClientAvailable()) {
            return BazaarUtilities.getBzrExecutable();
        }
        if (configureIfMissing) {
            BazaarUtilities.configureExecutable();
            return BazaarUtilities.getBzrExecutable();
        }
        return "bzr";
    }

    public static void configureExecutable() {
        BazaarUtilities.configureExecutable(EclipseBazaarUI.getStandardDisplay().getActiveShell());
    }

    public static void configureExecutable(Shell shell) {
        String[] dsplIds = new String[]{"org.vcs.bazaar.eclipse.ui.preferences.BazaarPreferencePage"};
        PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.vcs.bazaar.eclipse.ui.preferences.BazaarPreferencePage", (String[])dsplIds, null);
        dlg.open();
    }

    public static String getBzrUsername() {
        Preferences prefs = EclipseBazaarCore.getDefault().getPluginPreferences();
        return prefs.getString(BazaarPreference.BZR_EMAIL.name());
    }

    public static String getBzrUsername(boolean configureIfMissing) {
        String uname = BazaarUtilities.getBzrUsername();
        if (uname != null) {
            return uname;
        }
        if (configureIfMissing) {
            BazaarUtilities.configureUsername();
            return BazaarUtilities.getBzrUsername();
        }
        return System.getProperty("user.name");
    }

    public static void configureUsername() {
        String[] dsplIds = new String[]{"org.vcs.bazaar.eclipse.ui.preferences.BazaarPreferencePage"};
        Display display = PlatformUI.getWorkbench().getDisplay();
        PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)display.getActiveShell(), (String)"org.vcs.bazaar.eclipse.ui.preferences.BazaarPreferencePage", (String[])dsplIds, null);
        dlg.open();
    }

    public static IProject getProject(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj != null && obj instanceof IResource) {
            return ((IResource)obj).getProject();
        }
        return null;
    }
}

