/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.team;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.listeners.IResourceStateListener;
import org.vcs.bazaar.eclipse.core.subscriber.BazaarStatusSuscriber;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.UITexts;

public class BzrQuickDiffReferenceProvider
implements IQuickDiffReferenceProvider {
    public static final String ID = "org.vcs.bazaar.eclipse.quickdiff.providers.BazaarReferenceProvider";
    private String id;
    private ITextEditor editor = null;
    private IDocument document = null;
    private boolean isDocumentInitialized = false;
    private IDocumentProvider documentProvider = null;
    private SyncInfo syncInfo;
    private Job documentUpdateJob;
    private IResourceStateListener resourceStateListener = new IResourceStateListener(){

        public void resourceStateChanged(BzrChangeStateEvent event) {
            IFile file;
            if (BzrQuickDiffReferenceProvider.this.isDocumentInitialized && (file = BzrQuickDiffReferenceProvider.this.getFileFromEditor()) != null && event.getResources().contains(file)) {
                BzrQuickDiffReferenceProvider.this.updateDocument();
            }
        }
    };

    public IDocument getReference(IProgressMonitor monitor) throws CoreException {
        if (!this.isDocumentInitialized) {
            return null;
        }
        if (this.document == null) {
            this.readDocument(monitor);
        }
        return this.document;
    }

    public void setActiveEditor(ITextEditor targetEditor) {
        if (!(targetEditor.getEditorInput() instanceof IFileEditorInput)) {
            return;
        }
        this.editor = targetEditor;
        this.documentProvider = this.editor.getDocumentProvider();
        EclipseBazaarCore.addResourceStateListener((IResourceStateListener)this.resourceStateListener);
        this.isDocumentInitialized = true;
    }

    public boolean isEnabled() {
        if (!this.isDocumentInitialized) {
            return false;
        }
        IFile file = this.getFileFromEditor();
        return file != null && BzrWorkspaceRoot.getProviderFor((IProject)file.getProject()) != null;
    }

    public void dispose() {
        this.isDocumentInitialized = false;
        if (this.documentUpdateJob != null && this.documentUpdateJob.getState() != 0) {
            this.documentUpdateJob.cancel();
        }
        EclipseBazaarCore.removeResourceStateListener((IResourceStateListener)this.resourceStateListener);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private boolean computeChange(IProgressMonitor monitor) throws TeamException {
        boolean needToUpdateReferenceDocument = false;
        if (this.isDocumentInitialized) {
            SyncInfo info;
            IFile editorFile = this.getFileFromEditor();
            SyncInfo syncInfo = info = editorFile == null ? null : BazaarStatusSuscriber.getInstance().getSyncInfo((IResource)editorFile);
            if (info == null && this.syncInfo != null) {
                return true;
            }
            if (info == null) {
                return false;
            }
            if (this.syncInfo == null) {
                needToUpdateReferenceDocument = true;
            } else if (!this.syncInfo.equals((Object)info)) {
                needToUpdateReferenceDocument = true;
            }
            this.syncInfo = info;
        }
        return needToUpdateReferenceDocument;
    }

    private void readDocument(IProgressMonitor monitor) throws CoreException {
        if (!this.isDocumentInitialized) {
            return;
        }
        if (this.document == null) {
            this.document = new Document();
        }
        if (this.computeChange(monitor)) {
            IResourceVariant repoFile = this.syncInfo.getBase();
            if (repoFile != null && this.documentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.documentProvider;
                String encoding = provider.getEncoding((Object)this.editor.getEditorInput());
                if (encoding == null) {
                    encoding = provider.getDefaultEncoding();
                }
                if (!monitor.isCanceled()) {
                    InputStream stream = repoFile.getStorage(monitor).getContents();
                    if (stream == null || monitor.isCanceled() || !this.isDocumentInitialized) {
                        return;
                    }
                    BzrQuickDiffReferenceProvider.setDocumentContent(this.document, stream, encoding);
                }
            } else {
                if (monitor.isCanceled()) {
                    return;
                }
                this.document.set("");
            }
        }
    }

    private static void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        Reader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
                CharArrayWriter caw = new CharArrayWriter(15360);
                char[] readBuffer = new char[2048];
                int n = in.read(readBuffer);
                while (n > 0) {
                    caw.write(readBuffer, 0, n);
                    n = in.read(readBuffer);
                }
                document.set(caw.toString());
            }
            catch (IOException x) {
                throw new BazaarException(UITexts.error_QuickDiffProvider_readingFile, (Throwable)x);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException x) {
                    throw new BazaarException(UITexts.error_QuickDiffProvider_closingFile, (Throwable)x);
                }
            }
        }
    }

    private IFile getFileFromEditor() {
        IEditorInput input;
        IEditorInput iEditorInput = input = this.editor != null ? this.editor.getEditorInput() : null;
        if (input != null && input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    private void updateDocument() {
        if (!this.isDocumentInitialized) {
            return;
        }
        if (this.documentUpdateJob != null && this.documentUpdateJob.getState() != 0) {
            this.documentUpdateJob.cancel();
        }
        this.documentUpdateJob = new Job(UITexts.QuickDiffProvider_fetchingContents){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    BzrQuickDiffReferenceProvider.this.readDocument(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        this.documentUpdateJob.schedule();
    }
}

