/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.team;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public final class RefreshExecutionListener
implements IExecutionListener {
    private static final String REFRESH_ID = "org.eclipse.ui.file.refresh";

    public void addTo(ICommandService cmdService) {
        cmdService.getCommand(REFRESH_ID).addExecutionListener((IExecutionListener)this);
    }

    public void removeFrom(ICommandService cmdService) {
        if (cmdService != null) {
            cmdService.getCommand(REFRESH_ID).removeExecutionListener((IExecutionListener)this);
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getSelectionService().getSelection() instanceof IStructuredSelection) {
            HashSet<IResource> resources = new HashSet<IResource>();
            IStructuredSelection structuredSelection = (IStructuredSelection)window.getSelectionService().getSelection();
            for (Object selection : structuredSelection.toList()) {
                IProject proj;
                BazaarTeamProvider provider;
                IAdaptable adaptable;
                IResource res;
                if (!(selection instanceof IAdaptable) || (res = (IResource)(adaptable = (IAdaptable)selection).getAdapter(IResource.class)) == null || (provider = BzrWorkspaceRoot.getProviderFor((IProject)(proj = res.getProject()))) == null) continue;
                resources.add(res);
            }
            if (!resources.isEmpty()) {
                try {
                    EclipseBazaarCore.getDefault().getStatusCacheManager().scheduleRefresh(resources, (IProgressMonitor)new NullProgressMonitor(), 16);
                }
                catch (BazaarException e) {
                    EclipseBazaarCore.log((String)e.getStatus().getMessage(), (int)e.getStatus().getSeverity());
                }
            }
        }
    }
}

