/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.views;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.progress.IProgressService;
import org.vcs.bazaar.client.BazaarConflictType;
import org.vcs.bazaar.client.IBazaarConflict;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IResolveOptions;
import org.vcs.bazaar.eclipse.core.commands.ConflictsCommand;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.UIIcons;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.UIUtils;
import org.vcs.bazaar.eclipse.ui.actions.EditConflictsAction;
import org.vcs.bazaar.eclipse.ui.actions.ResolveAction;
import org.vcs.bazaar.eclipse.ui.views.BazaarView;
import org.vcs.bazaar.eclipse.ui.views.ConflictsViewComparator;

public class ConflictsView
extends BazaarView {
    public static final String VIEW_ID = "org.vcs.bazaar.eclipse.ui.views.ConflictsView";
    private TableViewer viewer;
    private IBzrBranch branch;

    public void resourceStateChanged(BzrChangeStateEvent event) {
    }

    public void setFocus() {
    }

    public void setInput(Object object) {
        if (object instanceof IBzrBranch) {
            this.refresh((IBzrBranch)object);
        }
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        Table table = new Table(container, 66304);
        table.setLayout((Layout)new GridLayout());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ConflictListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ConflictsViewComparator(ConflictsViewComparator.Order.ByType.ascending()));
        TableColumn type = new TableColumn(this.viewer.getTable(), 16384);
        type.setText(UITexts.ConflictsView_typeHeader);
        type.setResizable(true);
        UIUtils.addSizeLimiter(type);
        layout.setColumnData((Widget)type, (ColumnLayoutData)new ColumnWeightData(1));
        TableColumn path = new TableColumn(this.viewer.getTable(), 16384);
        path.setText(UITexts.ConflictsView_pathHeader);
        path.setResizable(true);
        UIUtils.addSizeLimiter(path);
        layout.setColumnData((Widget)path, (ColumnLayoutData)new ColumnWeightData(2));
        TableColumn message = new TableColumn(this.viewer.getTable(), 16384);
        message.setText(UITexts.ConflictsView_messageHeader);
        message.setResizable(false);
        UIUtils.addSizeLimiter(message);
        layout.setColumnData((Widget)message, (ColumnLayoutData)new ColumnWeightData(2));
        table.setSortDirection(128);
        table.setSortColumn(type);
        this.addDoubleClickListener();
        this.contributeToContextMenu();
        this.contributeToActionBars();
    }

    private void addDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IBazaarConflict conflict;
                IStructuredSelection selection = (IStructuredSelection)ConflictsView.this.viewer.getSelection();
                if (!selection.isEmpty() && (conflict = (IBazaarConflict)selection.getFirstElement()).getType() == BazaarConflictType.TEXT_CONFLICT) {
                    ConflictsView.this.editConflict(conflict);
                }
            }
        });
    }

    private void editConflict(IBazaarConflict conflict) {
        IFile resource = ResourceUtil.getIFileForLocation((String)this.branch.getPath().append(conflict.getPath()).toOSString());
        if (resource != null && resource instanceof IFile) {
            IRunnableWithProgress runnable = new IRunnableWithProgress((IResource)resource){
                private final /* synthetic */ IResource val$resource;
                {
                    this.val$resource = iResource;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    EditConflictsAction.runEditConflicts((IFile)this.val$resource);
                }
            };
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.run(false, false, runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void contributeToContextMenu() {
        final ConflictViewResolveAction markResolvedAction = new ConflictViewResolveAction(UITexts.ActionResolve_label, new Option[0]);
        final ConflictViewResolveAction resolveTakeThis = new ConflictViewResolveAction(UITexts.ActionResolveTakeThis_label, IResolveOptions.TAKE_THIS);
        final ConflictViewResolveAction resolveTakeOther = new ConflictViewResolveAction(UITexts.ActionResolveTakeOther_label, IResolveOptions.TAKE_OTHER);
        final ConflictViewEditConflictsAction editConflicts = new ConflictViewEditConflictsAction(UITexts.ActionEditConflicts_label);
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConflictsView.this.viewer.getSelection();
                markResolvedAction.selectionChanged(selection);
                resolveTakeOther.selectionChanged(selection);
                resolveTakeThis.selectionChanged(selection);
                editConflicts.selectionChanged(selection);
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                menuMgr.add((IContributionItem)new Separator("group.file"));
                menuMgr.add((IAction)editConflicts);
                menuMgr.add((IAction)resolveTakeThis);
                menuMgr.add((IAction)resolveTakeOther);
                menuMgr.add((IAction)markResolvedAction);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.viewer.getTable().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        Action toggleShowAffectedPathsAction = new Action(UITexts.View_Refresh, UIIcons.REFRESH){

            public void run() {
                ConflictsView.this.refresh(ConflictsView.this.branch);
            }
        };
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)toggleShowAffectedPathsAction);
        tbm.update(false);
        actionBars.updateActionBars();
    }

    public void refresh(final IBzrBranch branch) {
        this.branch = branch;
        if (branch == null) {
            this.viewer.setInput(null);
            this.viewer.refresh();
        } else {
            final ArrayList input = new ArrayList();
            Job job = new Job(UITexts.ConflictsView_refreshTaskName){

                protected IStatus run(IProgressMonitor monitor) {
                    ConflictsCommand cmd = new ConflictsCommand(branch);
                    try {
                        cmd.run(monitor);
                        List conflicts = cmd.getConflicts();
                        if (conflicts != null) {
                            input.addAll(conflicts);
                        }
                    }
                    catch (BazaarException bazaarException) {}
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        ConflictsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ConflictsView.this.viewer.setInput((Object)input.toArray());
                                ConflictsView.this.viewer.refresh();
                            }
                        });
                    }
                }
            });
            job.setUser(true);
            job.setPriority(30);
            job.schedule();
        }
    }

    private static class ConflictListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ConflictListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IBazaarConflict) {
                switch (columnIndex) {
                    case 0: {
                        return ((IBazaarConflict)element).getType().toString();
                    }
                    case 1: {
                        return ((IBazaarConflict)element).getPath();
                    }
                    case 2: {
                        return ((IBazaarConflict)element).getMessage();
                    }
                }
            }
            return "N/A";
        }
    }

    private class ConflictViewEditConflictsAction
    extends BaseSelectionListenerAction {
        protected ConflictViewEditConflictsAction(String text) {
            super(text);
        }

        public void run() {
            ConflictsView.this.editConflict((IBazaarConflict)this.getStructuredSelection().getFirstElement());
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                IBazaarConflict conflict = (IBazaarConflict)selection.getFirstElement();
                return conflict.getType() == BazaarConflictType.TEXT_CONFLICT;
            }
            return false;
        }
    }

    private class ConflictViewResolveAction
    extends BaseSelectionListenerAction {
        private final Option[] options;

        protected ConflictViewResolveAction(String text, Option ... options) {
            super(text);
            this.options = options;
        }

        public void run() {
            IStructuredSelection sel = this.getStructuredSelection();
            IBazaarConflict conflict = (IBazaarConflict)sel.getFirstElement();
            IFile resource = ResourceUtil.getIFileForLocation((String)ConflictsView.this.branch.getPath().append(conflict.getPath()).toOSString());
            if (resource != null) {
                IRunnableWithProgress runnable = new IRunnableWithProgress((IResource)resource){
                    private final /* synthetic */ IResource val$resource;
                    {
                        this.val$resource = iResource;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ResolveAction.runResolve(monitor, new IResource[]{this.val$resource}, ConflictViewResolveAction.this.options);
                        }
                        finally {
                            ConflictsView.this.refresh(ConflictsView.this.branch);
                        }
                    }
                };
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progressService.run(false, false, runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

