/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.views;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.vcs.bazaar.client.BazaarConflictType;
import org.vcs.bazaar.client.IBazaarConflict;

public class ConflictsViewComparator
extends ViewerComparator {
    public static final BazaarConflictType[] TYPE_ORDER = new BazaarConflictType[]{BazaarConflictType.TEXT_CONFLICT, BazaarConflictType.CONTENTS_CONFLICT, BazaarConflictType.PATH_CONFLICT, BazaarConflictType.DUPLICATE_ENTRY, BazaarConflictType.DUPLICATE_ID, BazaarConflictType.PARENT_LOOP, BazaarConflictType.MISSING_PARENT, BazaarConflictType.DELETING_PARENT, BazaarConflictType.UNVERSIONED_PARENT, BazaarConflictType.NON_DIRECTORY_PARENT, BazaarConflictType.UNKNOWN};

    public static Integer getWeight(BazaarConflictType type) {
        int i = 0;
        while (i < TYPE_ORDER.length) {
            if (type == TYPE_ORDER[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ConflictsViewComparator(Comparator comparator) {
        super(comparator);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.getComparator().compare(e1, e2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order implements Comparator<IBazaarConflict>
    {
        ByType{

            public int compare(IBazaarConflict o1, IBazaarConflict o2) {
                return ConflictsViewComparator.getWeight(o1.getType()).compareTo(ConflictsViewComparator.getWeight(o2.getType()));
            }
        }
        ,
        ByPath{

            public int compare(IBazaarConflict o1, IBazaarConflict o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        };


        public Comparator<IBazaarConflict> ascending() {
            return this;
        }

        public Comparator<IBazaarConflict> descending() {
            return Collections.reverseOrder(this);
        }
    }
}

