/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.views;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.vcs.bazaar.eclipse.core.history.BazaarFileHistory;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.model.IBzrMissingRevisions;
import org.vcs.bazaar.eclipse.ui.history.AffectedPathsViewer;
import org.vcs.bazaar.eclipse.ui.history.HistoryTreeViewer;
import org.vcs.bazaar.eclipse.ui.views.BazaarView;

public class MissingView
extends BazaarView {
    public static final String VIEW_ID = "org.vcs.bazaar.eclipse.ui.views.MissingView";
    private IBzrMissingRevisions missingRevisions;
    private Composite missingControl;
    private Composite extraControl;
    private TreeViewer missingViewer;
    private TreeViewer extraViewer;
    private AffectedPathsViewer missingPathsViewer;
    private AffectedPathsViewer extraPathsViewer;
    private static final int DEFAULT_WEIGHT = 1;
    private static final int MAX_WEIGHT = 10;
    private Label missingLabel;

    public void createPartControl(Composite parent) {
        SashForm control = new SashForm(parent, 512);
        control.setLayoutData((Object)new GridData(1808));
        this.missingControl = new Composite((Composite)control, 0);
        this.missingControl.setLayout((Layout)new GridLayout(1, false));
        this.missingControl.setLayoutData((Object)new GridData(1808));
        this.missingLabel = new Label(this.missingControl, 2048);
        this.missingLabel.setText("Missing revisions");
        this.setTitleListener(this.missingLabel, control);
        this.missingViewer = new HistoryTreeViewer(this.missingControl, 4, new HistoryTreeViewer.Column[0]);
        this.extraControl = new Composite((Composite)control, 0);
        this.extraControl.setLayout((Layout)new GridLayout(1, false));
        this.extraControl.setLayoutData((Object)new GridData(-1, 20));
        Label label = new Label(this.extraControl, 2048);
        label.setText("Extra revisions");
        this.setTitleListener(label, control);
        this.extraViewer = new HistoryTreeViewer(this.extraControl, 0, new HistoryTreeViewer.Column[0]);
        control.setWeights(new int[]{1, 1});
    }

    private void setTitleListener(Label label, final SashForm parent) {
        label.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.getSource() instanceof Label) {
                    int[] weights = parent.getWeights();
                    if (MissingView.this.missingLabel == e.getSource()) {
                        parent.setWeights(new int[]{weights[0] > weights[1] ? 1 : 10, 1});
                    } else {
                        parent.setWeights(new int[]{1, weights[1] > weights[0] ? 1 : 10});
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void setFocus() {
    }

    public void resourceStateChanged(BzrChangeStateEvent event) {
    }

    public void setInput(Object object) {
        if (object instanceof IBzrMissingRevisions) {
            this.missingRevisions = (IBzrMissingRevisions)object;
        }
        this.refresh();
    }

    private void refresh() {
        this.populateMissingRevisions();
        this.populateExtraRevisions();
    }

    private void populateExtraRevisions() {
        this.extraViewer.setInput((Object)new BazaarFileHistory(this.missingRevisions.getExtraRevisions()));
    }

    private void populateMissingRevisions() {
        this.missingViewer.setInput((Object)new BazaarFileHistory(this.missingRevisions.getMissingRevisions()));
    }
}

