/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.OpenFileAction;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.StatusCommand;
import org.vcs.bazaar.eclipse.core.history.BazaarFileHistory;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UIIcons;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.UIUtils;
import org.vcs.bazaar.eclipse.ui.actions.ReplaceWithLatestAction;
import org.vcs.bazaar.eclipse.ui.compare.CompareUtils;
import org.vcs.bazaar.eclipse.ui.history.HistoryTreeViewer;
import org.vcs.bazaar.eclipse.ui.views.BazaarView;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionComparator;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionPathLabelProvider;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionStatusLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusView
extends BazaarView {
    public static final String VIEW_ID = "org.vcs.bazaar.eclipse.ui.views.StatusView";
    private static HistoryTreeViewer.Column[] columns = new HistoryTreeViewer.Column[]{HistoryTreeViewer.Column.REVID, HistoryTreeViewer.Column.COMMITTER, HistoryTreeViewer.Column.TIMESTAMP, HistoryTreeViewer.Column.MESSAGE};
    private SashForm container;
    private TableViewer viewer;
    private HistoryTreeViewer mergeViewer;
    private IResource[] input;

    @Override
    public void setInput(Object object) {
        if (object instanceof IResource[]) {
            this.input = (IResource[])object;
            this.refresh();
        }
    }

    private void refresh() {
        if (this.input == null || this.input.length == 0) {
            this.viewer.setInput(null);
            this.viewer.refresh();
        } else {
            final AtomicReference status = new AtomicReference();
            final ArrayList pendingMerges = new ArrayList();
            Job job = new Job(UITexts.StatusView_refreshTaskName){

                protected IStatus run(IProgressMonitor monitor) {
                    StatusCommand cmd = new StatusCommand(BzrWorkspaceRoot.getBzrResourcesFor((IResource[])StatusView.this.input));
                    try {
                        cmd.run(monitor);
                        status.set(cmd.getStatus());
                        pendingMerges.addAll(cmd.getPendingMerges());
                        IBzrResourceStatus[] iBzrResourceStatusArray = cmd.getStatus();
                        int n = iBzrResourceStatusArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBzrResourceStatus status2 = iBzrResourceStatusArray[n2];
                            if (!status2.isIgnored() && !status2.isUnchanged() && status2.getResource().getIResource().getType() != 4) {
                                EclipseBazaarUI.getDefault().getConsole().logMessage(status2.getStatus().toString());
                            }
                            ++n2;
                        }
                        if (cmd.getPendingMerges().size() > 0) {
                            EclipseBazaarUI.getDefault().getConsole().logMessage("pending merges:\n");
                            StatusView.this.showPendingMerges(cmd.getPendingMerges(), new StringBuilder());
                        }
                    }
                    catch (BazaarException bazaarException) {}
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        StatusView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (pendingMerges.isEmpty()) {
                                    StatusView.this.container.setMaximizedControl((Control)StatusView.this.viewer.getControl().getParent());
                                } else {
                                    StatusView.this.container.setMaximizedControl(null);
                                }
                                StatusView.this.viewer.setInput(status.get());
                                StatusView.this.mergeViewer.setInput(new BazaarFileHistory(pendingMerges));
                                StatusView.this.viewer.refresh();
                            }
                        });
                    }
                }
            });
            job.setUser(true);
            job.setPriority(30);
            job.schedule();
        }
    }

    protected void showPendingMerges(List<IBazaarLogMessage> pendingMerges, StringBuilder tab) {
        tab.append("    ");
        for (IBazaarLogMessage log : pendingMerges) {
            StringBuilder sb = new StringBuilder(100);
            sb.append(tab.toString()).append(log.getAuthor()).append(" ").append(log.getTimeStamp()).append(" ").append(log.getMessage());
            EclipseBazaarUI.getDefault().getConsole().logMessage(sb.toString());
            if (log.getMerged() == null) continue;
            this.showPendingMerges(log.getMerged(), new StringBuilder(tab.toString()));
        }
    }

    public void createPartControl(Composite parent) {
        this.container = new SashForm(parent, 512);
        this.container.setLayoutData((Object)new GridData(1808));
        Composite tableContainer = new Composite((Composite)this.container, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableContainer.setLayout((Layout)layout);
        Table table = new Table(tableContainer, 66304);
        table.setLayout((Layout)new GridLayout());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new BzrResourceSelectionComparator(BzrResourceSelectionComparator.Order.ByStatus.ascending()));
        TableColumn status = new TableColumn(this.viewer.getTable(), 0);
        status.setText(UITexts.CommitDialog_fileStatusHeader);
        status.setMoveable(false);
        status.setResizable(true);
        UIUtils.addSizeLimiter(status);
        layout.setColumnData((Widget)status, (ColumnLayoutData)new ColumnWeightData(1));
        TableColumn file = new TableColumn(this.viewer.getTable(), 0);
        file.setText(UITexts.CommitDialog_fileNameHeader);
        file.setResizable(false);
        file.setMoveable(false);
        UIUtils.addSizeLimiter(file);
        layout.setColumnData((Widget)file, (ColumnLayoutData)new ColumnWeightData(10));
        new TableViewerColumn(this.viewer, status).setLabelProvider((CellLabelProvider)new BzrResourceSelectionStatusLabelProvider());
        new TableViewerColumn(this.viewer, file).setLabelProvider((CellLabelProvider)new BzrResourceSelectionPathLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        table.setSortDirection(128);
        table.setSortColumn(status);
        this.mergeViewer = new HistoryTreeViewer((Composite)this.container, columns);
        this.container.setMaximizedControl((Control)this.viewer.getControl().getParent());
        this.contributeToContextMenu();
        this.contributeToActionBars();
        this.addDoubleClickListener();
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        Action toggleShowAffectedPathsAction = new Action(UITexts.View_Refresh, UIIcons.REFRESH){

            public void run() {
                StatusView.this.refresh();
            }
        };
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)toggleShowAffectedPathsAction);
        tbm.update(false);
        actionBars.updateActionBars();
    }

    private void contributeToContextMenu() {
        final StatusViewDiffAction diffAction = new StatusViewDiffAction(UITexts.ActionCompareWithLatest_label);
        final StatusViewOpenAction openAction = new StatusViewOpenAction(UITexts.ActionOpenInEditor_label);
        final StatusViewRevertAction revertAction = new StatusViewRevertAction(UITexts.ActionRevert_label);
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)StatusView.this.viewer.getSelection();
                diffAction.selectionChanged(selection);
                openAction.selectionChanged(selection);
                revertAction.selectionChanged(selection);
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                menuMgr.add((IContributionItem)new Separator("group.file"));
                menuMgr.add((IAction)diffAction);
                menuMgr.add((IAction)openAction);
                menuMgr.add((IAction)revertAction);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.viewer.getTable().setMenu(menu);
    }

    private void addDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)StatusView.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    IBzrResourceStatus status = (IBzrResourceStatus)selection.getFirstElement();
                    if (status.isModified()) {
                        StatusView.this.compareWithLatest(status);
                    } else if (status.getResource().getIResource().getType() == 1) {
                        StatusView.this.openInEditor(status);
                    }
                }
            }
        });
    }

    private void openInEditor(IBzrResourceStatus status) {
        OpenFileAction ofa = new OpenFileAction(this.getSite().getWorkbenchWindow().getActivePage());
        ofa.selectionChanged((IStructuredSelection)new StructuredSelection((Object)status.getResource().getIResource()));
        ofa.run();
    }

    private void compareWithLatest(IBzrResourceStatus status) {
        IResource resource = status.getResource().getIResource();
        CompareUtils.openSaveableEditor(resource, new IStorageBazaarRevision(resource), this.getSite().getWorkbenchWindow().getActivePage());
    }

    public void setFocus() {
    }

    public void resourceStateChanged(BzrChangeStateEvent event) {
    }

    private class StatusViewDiffAction
    extends BaseSelectionListenerAction {
        protected StatusViewDiffAction(String text) {
            super(text);
        }

        public void run() {
            StatusView.this.compareWithLatest((IBzrResourceStatus)this.getStructuredSelection().getFirstElement());
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                IBzrResourceStatus status = (IBzrResourceStatus)selection.getFirstElement();
                return status.isModified();
            }
            return false;
        }
    }

    private class StatusViewOpenAction
    extends BaseSelectionListenerAction {
        protected StatusViewOpenAction(String text) {
            super(text);
        }

        public void run() {
            StatusView.this.openInEditor((IBzrResourceStatus)this.getStructuredSelection().getFirstElement());
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                IBzrResourceStatus status = (IBzrResourceStatus)selection.getFirstElement();
                return status.getResource().getIResource().getType() == 1;
            }
            return false;
        }
    }

    private class StatusViewRevertAction
    extends BaseSelectionListenerAction {
        protected StatusViewRevertAction(String text) {
            super(text);
        }

        public void run() {
            ReplaceWithLatestAction rwla = new ReplaceWithLatestAction();
            IBzrResourceStatus status = (IBzrResourceStatus)this.getStructuredSelection().getFirstElement();
            rwla.selectionChanged(null, (ISelection)new StructuredSelection((Object)status.getResource().getIResource()));
            rwla.run((IAction)new Action(UITexts.ActionRevert_label){});
            StatusView.this.refresh();
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                IBzrResourceStatus status = (IBzrResourceStatus)selection.getFirstElement();
                return !status.isUnknown();
            }
            return false;
        }
    }
}

