/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.widgets;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;

public class BzrResourceSelectionComparator
extends ViewerComparator {
    public static final BazaarStatusKind[] STATUS_ORDER = new BazaarStatusKind[]{BazaarStatusKind.HAS_CONFLICTS, BazaarStatusKind.CREATED, BazaarStatusKind.MODIFIED, BazaarStatusKind.DELETED, BazaarStatusKind.RENAMED, BazaarStatusKind.KIND_CHANGED, BazaarStatusKind.UNKNOWN};

    public static Integer getStatusWeight(IBzrResourceStatus status) {
        int i = 0;
        while (i < STATUS_ORDER.length) {
            if (status.contains(STATUS_ORDER[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public BzrResourceSelectionComparator(Comparator comparator) {
        super(comparator);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.getComparator().compare(e1, e2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order implements Comparator<IBzrResourceStatus>
    {
        ByStatus{

            public int compare(IBzrResourceStatus o1, IBzrResourceStatus o2) {
                int result = BzrResourceSelectionComparator.getStatusWeight(o1).compareTo(BzrResourceSelectionComparator.getStatusWeight(o2));
                if (result == 0) {
                    result = o1.getStatus().getPath().compareTo(o2.getStatus().getPath());
                }
                return result;
            }
        }
        ,
        ByFile{

            public int compare(IBzrResourceStatus o1, IBzrResourceStatus o2) {
                return o1.getStatus().getPath().compareTo(o2.getStatus().getPath());
            }
        };


        public Comparator<IBzrResourceStatus> ascending() {
            return this;
        }

        public Comparator<IBzrResourceStatus> descending() {
            return Collections.reverseOrder(this);
        }
    }
}

