/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.widgets;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UIIcons;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.UIUtils;
import org.vcs.bazaar.eclipse.ui.compare.CompareUtils;
import org.vcs.bazaar.eclipse.ui.dialogs.UntrackedFilesFilter;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceHeaderSelectionListener;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionComparator;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionPathLabelProvider;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionStatusLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BzrResourceSelectionComposite {
    private Composite control;
    private TableViewer tableViewer;
    private List<IBzrResourceStatus> resources;
    private List<IBzrResourceStatus> selection;
    private UntrackedFilesFilter untrackedFilesFilter;
    private boolean filterUntracked = false;
    private boolean checkBox = true;
    private ListenerList checkStateListeners = new ListenerList();
    private boolean showUntrackedButton;
    private ToolItem untrackedFilesButton;

    public BzrResourceSelectionComposite(boolean checkBox, boolean showUntrackedButton) {
        this.selection = Collections.emptyList();
        this.resources = this.selection;
        this.untrackedFilesFilter = new UntrackedFilesFilter();
        this.checkBox = checkBox;
        this.showUntrackedButton = showUntrackedButton;
    }

    public BzrResourceSelectionComposite() {
        this(true, false);
    }

    private void createFilesList(Composite parent) {
        int tableStyle = this.checkBox ? 68386 : 66306;
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        Table table = new Table(container, tableStyle);
        table.setLayout((Layout)new GridLayout());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn status = new TableColumn(table, 16384);
        status.setText(UITexts.CommitDialog_fileStatusHeader);
        status.setMoveable(false);
        status.setResizable(true);
        UIUtils.addSizeLimiter(status);
        layout.setColumnData((Widget)status, (ColumnLayoutData)new ColumnWeightData(50, false));
        TableColumn file = new TableColumn(table, 16384);
        file.setText(UITexts.CommitDialog_fileNameHeader);
        file.setResizable(false);
        file.setMoveable(false);
        UIUtils.addSizeLimiter(file);
        layout.setColumnData((Widget)file, (ColumnLayoutData)new ColumnWeightData(400, false));
        this.tableViewer = this.checkBox ? new CheckboxTableViewer(table) : new TableViewer(table);
        status.addSelectionListener((SelectionListener)new BzrResourceHeaderSelectionListener(this.tableViewer, BzrResourceSelectionComparator.Order.ByStatus));
        file.addSelectionListener((SelectionListener)new BzrResourceHeaderSelectionListener(this.tableViewer, BzrResourceSelectionComparator.Order.ByFile));
        this.tableViewer.setComparator((ViewerComparator)new BzrResourceSelectionComparator(BzrResourceSelectionComparator.Order.ByStatus.ascending()));
        new TableViewerColumn(this.tableViewer, status).setLabelProvider((CellLabelProvider)new BzrResourceSelectionStatusLabelProvider());
        new TableViewerColumn(this.tableViewer, file).setLabelProvider((CellLabelProvider)new BzrResourceSelectionPathLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        table.setSortDirection(128);
        table.setSortColumn(status);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)BzrResourceSelectionComposite.this.tableViewer.getSelection();
                if (sel.getFirstElement() instanceof IBzrResourceStatus) {
                    IBzrResourceStatus status = (IBzrResourceStatus)sel.getFirstElement();
                    if ((status.isAdded() || status.isUnknown()) && status.getResource().getIResource().getType() == 1 && EclipseBazaarUI.getActivePage() != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)EclipseBazaarUI.getActivePage(), (IFile)((IFile)status.getResource().getIResource()));
                        }
                        catch (PartInitException e) {
                            EclipseBazaarUI.log((CoreException)((Object)e));
                        }
                    } else if (!status.isDeleted() && status.getResource().getIResource().getType() == 1) {
                        CompareUtils.openDialog(status.getResource().getIResource());
                    }
                }
            }
        });
        if (this.checkBox) {
            ((CheckboxTableViewer)this.tableViewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    BzrResourceSelectionComposite.this.fireCheckStateChanged(event);
                }
            });
            Action selectAllAction = new Action(UITexts.CommitDialog_selectAll){

                public void run() {
                    ((CheckboxTableViewer)BzrResourceSelectionComposite.this.tableViewer).setAllChecked(true);
                    BzrResourceSelectionComposite.this.fireCheckStateChanged(null);
                }
            };
            Action deselectAllAction = new Action(UITexts.CommitDialog_deselectAll){

                public void run() {
                    ((CheckboxTableViewer)BzrResourceSelectionComposite.this.tableViewer).setAllChecked(false);
                    BzrResourceSelectionComposite.this.fireCheckStateChanged(null);
                }
            };
            MenuManager menuMgr = new MenuManager();
            this.tableViewer.getControl().setMenu(menuMgr.createContextMenu(this.tableViewer.getControl()));
            menuMgr.add((IAction)selectAllAction);
            menuMgr.add((IAction)deselectAllAction);
        }
        GridDataFactory gf = GridDataFactory.fillDefaults().align(4, 4).grab(true, true);
        gf.applyTo((Control)container);
        status.pack();
    }

    protected String getUpperLabel() {
        return "Changes";
    }

    protected void createUpperControls(Composite container) {
        Composite upperContainer = new Composite(container, 0);
        upperContainer.setLayout((Layout)new GridLayout(2, false));
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 3;
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        upperContainer.setLayoutData((Object)data2);
        Label filesLabel = new Label(upperContainer, 768);
        filesLabel.setText(this.getUpperLabel());
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 3;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        filesLabel.setLayoutData((Object)data);
        ToolBar toolbar = new ToolBar(upperContainer, 0x800000);
        this.createUpperButtons(toolbar);
    }

    public Composite createControls(Composite container) {
        this.control = new Composite(container, 0);
        this.control.setLayout((Layout)new GridLayout());
        this.createUpperControls(this.control);
        this.createMiddleControls(this.control);
        this.createBottomControls(this.control);
        return this.control;
    }

    protected void createBottomControls(Composite control) {
        Composite optionComposite = this.createOptionComposite(control);
        this.createOption(optionComposite);
    }

    protected void createMiddleControls(Composite control) {
        this.createFilesList(control);
    }

    protected void createOption(Composite optionComposite) {
    }

    protected Composite createOptionComposite(Composite container) {
        Composite optionsContainer = new Composite(container, 0);
        optionsContainer.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 3;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        optionsContainer.setLayoutData((Object)data);
        return optionsContainer;
    }

    protected void createUpperButtons(ToolBar toolbar) {
        if (this.showUntrackedButton) {
            this.untrackedFilesButton = this.addToolBarItem(toolbar, 32, UIIcons.UNTRACKED_FILE, UITexts.CommitDialog_checkboxUntracked, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (BzrResourceSelectionComposite.this.untrackedFilesButton.getSelection()) {
                        BzrResourceSelectionComposite.this.removeUntrackedFilesFilter();
                        TableColumn[] tableColumnArray = BzrResourceSelectionComposite.this.getTableViewer().getTable().getColumns();
                        int n = tableColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableColumn column = tableColumnArray[n2];
                            column.pack();
                            ++n2;
                        }
                    } else {
                        BzrResourceSelectionComposite.this.addUntrackedFilesFilter();
                    }
                    BzrResourceSelectionComposite.this.getTableViewer().refresh(true);
                }
            });
            this.untrackedFilesButton.setSelection(!this.isFilterUntracked());
        }
        if (this.checkBox) {
            this.addToolBarItem(toolbar, 8, UIIcons.CHECK_ALL, UITexts.CommitDialog_selectAll, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (BzrResourceSelectionComposite.this.checkBox && BzrResourceSelectionComposite.this.tableViewer.getTable().getEnabled()) {
                        ((CheckboxTableViewer)BzrResourceSelectionComposite.this.tableViewer).setAllChecked(true);
                        BzrResourceSelectionComposite.this.fireCheckStateChanged(null);
                    }
                }
            });
            this.addToolBarItem(toolbar, 8, UIIcons.UNCHECK_ALL, UITexts.CommitDialog_deselectAll, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (BzrResourceSelectionComposite.this.checkBox && BzrResourceSelectionComposite.this.tableViewer.getTable().getEnabled()) {
                        ((CheckboxTableViewer)BzrResourceSelectionComposite.this.tableViewer).setAllChecked(false);
                        BzrResourceSelectionComposite.this.fireCheckStateChanged(null);
                    }
                }
            });
        }
    }

    protected ToolItem addToolBarItem(ToolBar toolbar, int style, ImageDescriptor imageDescriptor, String tooltip, SelectionAdapter selectionAdapter) {
        ToolItem item = new ToolItem(toolbar, style);
        final Image image = imageDescriptor.createImage();
        item.setImage(image);
        item.setToolTipText(tooltip);
        item.addSelectionListener((SelectionListener)selectionAdapter);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                image.dispose();
            }
        });
        return item;
    }

    public void addUntrackedFilesFilter() {
        if (!this.filterUntracked) {
            if (this.untrackedFilesButton != null) {
                this.untrackedFilesButton.setSelection(false);
            }
            this.tableViewer.addFilter((ViewerFilter)this.untrackedFilesFilter);
            this.filterUntracked = true;
            this.fireCheckStateChanged(null);
        }
    }

    public void removeUntrackedFilesFilter() {
        if (this.filterUntracked) {
            if (this.untrackedFilesButton != null) {
                this.untrackedFilesButton.setSelection(true);
            }
            this.tableViewer.removeFilter((ViewerFilter)this.untrackedFilesFilter);
            this.filterUntracked = false;
            this.fireCheckStateChanged(null);
        }
    }

    public void addUntrackedFilesFilterIfNoUntrackedSelected() {
        boolean filter = true;
        for (IBzrResourceStatus status : this.selection) {
            if (!status.isUnknown() || status.getResource() == null || status.getResource().isFolder()) continue;
            filter = false;
            break;
        }
        if (filter) {
            filter = false;
            for (IBzrResourceStatus status : this.resources) {
                if (status.isUnknown()) continue;
                filter = true;
                break;
            }
        }
        if (filter) {
            this.addUntrackedFilesFilter();
        }
    }

    public void setResources(List<IBzrResourceStatus> resources) {
        this.resources = resources;
    }

    public List<IBzrResourceStatus> getResources() {
        return this.resources;
    }

    public List<IBzrResourceStatus> getSelection() {
        if (this.checkBox) {
            Object[] checkedElements = ((CheckboxTableViewer)this.tableViewer).getCheckedElements();
            this.selection.clear();
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object checked = objectArray[n2];
                this.selection.add((IBzrResourceStatus)checked);
                ++n2;
            }
        }
        return this.selection;
    }

    public void setSelection(List<IBzrResourceStatus> selection) {
        this.selection = selection;
    }

    public boolean isFilterUntracked() {
        return this.filterUntracked;
    }

    public void refreshTableViewer() {
        this.tableViewer.setInput(this.resources);
        this.tableViewer.refresh(true);
        if (this.checkBox) {
            ((CheckboxTableViewer)this.tableViewer).setAllChecked(false);
            for (IBzrResourceStatus bzrResourceStatus : this.selection) {
                ((CheckboxTableViewer)this.tableViewer).setChecked((Object)bzrResourceStatus, true);
            }
            this.fireCheckStateChanged(null);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add((Object)listener);
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent event) {
        Object[] array = this.checkStateListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }
}

