/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.ui.UITexts;

public class BzrResourceSelectionPathLabelProvider
extends ColumnLabelProvider {
    private static final Map<BazaarStatusKind, String> FILE_STATUS_DESCRIPTION = new HashMap<BazaarStatusKind, String>(6);

    static {
        FILE_STATUS_DESCRIPTION.put(BazaarStatusKind.HAS_CONFLICTS, UITexts.CommitDialog_statusConflict);
        FILE_STATUS_DESCRIPTION.put(BazaarStatusKind.CREATED, UITexts.CommitDialog_statusAdded);
        FILE_STATUS_DESCRIPTION.put(BazaarStatusKind.MODIFIED, UITexts.CommitDialog_statusModified);
        FILE_STATUS_DESCRIPTION.put(BazaarStatusKind.DELETED, UITexts.CommitDialog_statusRemoved);
        FILE_STATUS_DESCRIPTION.put(BazaarStatusKind.RENAMED, UITexts.CommitDialog_statusRenamed);
        FILE_STATUS_DESCRIPTION.put(BazaarStatusKind.UNKNOWN, UITexts.CommitDialog_statusUntracked);
        FILE_STATUS_DESCRIPTION.put(BazaarStatusKind.X_BIT_CHANGED, UITexts.CommitDialog_statusExecuteBitChanged);
    }

    public String getText(Object obj) {
        return ((IBzrResourceStatus)obj).getStatus().getPath();
    }

    public String getToolTipText(Object element) {
        IBzrResourceStatus resource = (IBzrResourceStatus)element;
        String text = "";
        if (resource.isHasConflicts()) {
            text = FILE_STATUS_DESCRIPTION.get(BazaarStatusKind.HAS_CONFLICTS);
        } else if (resource.isAdded()) {
            text = FILE_STATUS_DESCRIPTION.get(BazaarStatusKind.CREATED);
        } else if (resource.isModified()) {
            text = FILE_STATUS_DESCRIPTION.get(BazaarStatusKind.MODIFIED);
        } else if (resource.isDeleted()) {
            text = FILE_STATUS_DESCRIPTION.get(BazaarStatusKind.DELETED);
        } else if (resource.isUnknown()) {
            text = FILE_STATUS_DESCRIPTION.get(BazaarStatusKind.UNKNOWN);
        }
        if (resource.isRenamed()) {
            if (!text.isEmpty()) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + UITexts.bind((String)FILE_STATUS_DESCRIPTION.get(BazaarStatusKind.RENAMED), (Object)resource.getStatus().getPreviousPath());
        }
        if (resource.isXBitChanged()) {
            if (!text.isEmpty()) {
                text = String.valueOf(text) + " ";
            }
            text = String.valueOf(text) + FILE_STATUS_DESCRIPTION.get(BazaarStatusKind.X_BIT_CHANGED);
        }
        return text;
    }
}

