/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.eclipse.ui.UITexts;

public class RevisionNumber
extends Composite {
    private static final int REVISION_WIDTH_HINT = 65;
    private Text revisionText;
    private Button tipButton;
    private Button revisionButton;
    private Composite control;
    private Button logButton;

    public RevisionNumber(Composite parent) {
        super(parent, 0);
        this.createControl();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RevisionNumber.this.dispose();
            }
        });
        this.setLayout(parent.getLayout());
    }

    private void createControl() {
        this.control = new Composite((Composite)this, 0);
        GridLayout revisionLayout = new GridLayout(3, false);
        this.control.setLayout((Layout)revisionLayout);
        this.control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tipButton = new Button(this.control, 16);
        this.tipButton.setText(UITexts.SelectRevision_tip);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.tipButton.setLayoutData((Object)data);
        this.tipButton.setSelection(true);
        this.revisionButton = new Button(this.control, 16);
        this.revisionButton.setText(UITexts.SelectRevision_revision);
        this.revisionText = new Text(this.control, 2048);
        data = new GridData();
        data.widthHint = 65;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        this.logButton = new Button(this.control, 8);
        this.logButton.setText(UITexts.SelectRevision_showLog);
        SelectionAdapter revisionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionNumber.this.revisionText.setEnabled(RevisionNumber.this.revisionButton.getSelection());
                if (RevisionNumber.this.revisionButton.getSelection()) {
                    RevisionNumber.this.revisionText.selectAll();
                    RevisionNumber.this.revisionText.setFocus();
                }
            }
        };
        this.tipButton.addSelectionListener((SelectionListener)revisionListener);
        this.revisionButton.addSelectionListener((SelectionListener)revisionListener);
    }

    public void addShowLogButtonSelectionListener(SelectionListener listener) {
        this.logButton.addSelectionListener(listener);
    }

    public String getRevision() {
        return this.revisionText.getText();
    }

    public boolean isRevisionSelected() {
        return this.revisionButton.getSelection();
    }

    public boolean isTipSelected() {
        return this.tipButton.getSelection();
    }

    public void setRevision(String revisionText) {
        this.revisionText.setText(revisionText);
        this.selectRevisionButton(true);
        this.selectTipButton(false);
        this.revisionText.setEnabled(true);
    }

    public void selectTipButton(boolean selected) {
        this.tipButton.setSelection(selected);
    }

    public void selectRevisionButton(boolean selected) {
        this.revisionButton.setSelection(selected);
    }

    public void setEnabled(boolean enabled) {
        this.revisionButton.setEnabled(enabled);
        this.revisionText.setEnabled(enabled);
        this.tipButton.setEnabled(enabled);
        this.logButton.setEnabled(enabled);
        this.control.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void dispose() {
        this.revisionButton.dispose();
        this.revisionText.dispose();
        this.tipButton.dispose();
        this.control.dispose();
        super.dispose();
    }

    public void setVisible(boolean visible) {
        this.revisionButton.setVisible(visible);
        this.revisionText.setVisible(visible);
        this.tipButton.setVisible(visible);
        this.control.setVisible(visible);
        super.setVisible(visible);
    }

    public void showLogButton(boolean visible) {
        this.logButton.setVisible(visible);
    }
}

