/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.configuration;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.InitAction;
import org.vcs.bazaar.eclipse.ui.decorator.BazaarLightweightDecorator;
import org.vcs.bazaar.eclipse.ui.team.BazaarUtilities;
import org.vcs.bazaar.eclipse.ui.wizards.configuration.BranchRootPage;

public class BazaarConfigurationWizard
extends Wizard
implements IConfigurationWizard {
    private IProject project;
    private BranchRootPage branchRootPage;

    public BazaarConfigurationWizard() {
        this.setWindowTitle(UITexts.ConfigurationWizard_wizardTitle);
    }

    public void addPages() {
        if (this.project == null) {
            return;
        }
        this.branchRootPage = new BranchRootPage(this.project);
        this.addPage((IWizardPage)this.branchRootPage);
    }

    public boolean performFinish() {
        if (!this.branchRootPage.isExistingBranch()) {
            new InitAction(this.branchRootPage.getPath(), this.project, this.getShell()).run(null);
        }
        try {
            BazaarTeamProvider.registerProject((IProject)this.project);
        }
        catch (CoreException e) {
            EclipseBazaarUI.getDefault().getLog().log(e.getStatus());
            return false;
        }
        BazaarLightweightDecorator.refresh();
        return true;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
        if (!EclipseBazaarCore.getDefault().isClientAvailable()) {
            BazaarUtilities.configureExecutable();
        }
    }
}

