/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.configuration;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.wizards.BzrWizardPage;
import org.vcs.bazaar.eclipse.ui.wizards.configuration.BazaarConfigurationWizard;

public class BranchRootPage
extends BzrWizardPage {
    private IPath bzrPath;
    private IPath bzrPathOriginal;
    private IPath foundBzrPath;

    public BranchRootPage(IProject project) {
        super(BranchRootPage.class.getName(), UITexts.ConfigurationWizard_wizard_page_title);
        IPath repoPath = ResourceUtil.getRepositoryPath((IResource)project);
        if (repoPath == null) {
            this.foundBzrPath = null;
            this.bzrPath = this.bzrPathOriginal = project.getLocation();
            this.setDescription(UITexts.ConfigurationWizard_version_control_new_project);
        } else {
            this.bzrPathOriginal = this.foundBzrPath = repoPath;
            this.bzrPath = this.foundBzrPath;
            this.setDescription(UITexts.ConfigurationWizard_version_control_existing_project);
        }
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite mainControl = new Composite(parent, 0);
        mainControl.setLayout((Layout)new GridLayout(3, false));
        new Label(mainControl, 0x1000000).setText(UITexts.ConfigurationWizard_label_select_dir);
        final Text directoryText = new Text(mainControl, 2048);
        directoryText.setLayoutData((Object)new GridData(768));
        directoryText.setText(this.bzrPath.toString());
        directoryText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchRootPage.this.setPath(new Path(directoryText.getText()));
                directoryText.setText(BranchRootPage.this.getPath().toString());
            }
        });
        Button changeDirButton = new Button(mainControl, 0x1000008);
        changeDirButton.setText(UITexts.ConfigurationWizard_button_change_dir);
        changeDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(new Shell());
                directoryDialog.setText(UITexts.ConfigurationWizard_button_select_bzr_root);
                directoryDialog.setMessage(UITexts.ConfigurationWizard_button_select_bzr_root_msg);
                BranchRootPage.this.setPath(new Path(directoryDialog.open()));
                directoryText.setText(BranchRootPage.this.bzrPath.toString());
            }
        });
        Button restoreDefaultDirButton = new Button(mainControl, 0x1000008);
        restoreDefaultDirButton.setText(UITexts.ConfigurationWizard_button_use_project_root);
        restoreDefaultDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchRootPage.this.setDefaultPath();
                directoryText.setText(BranchRootPage.this.bzrPath.toString());
            }
        });
        Button restoreExistingDirButton = new Button(mainControl, 0x1000008);
        restoreExistingDirButton.setText(UITexts.ConfigurationWizard_button_use_existing_bzr_dir);
        restoreExistingDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BranchRootPage.this.foundBzrPath != null) {
                    BranchRootPage.this.bzrPath = BranchRootPage.this.foundBzrPath;
                    directoryText.setText(BranchRootPage.this.bzrPath.toString());
                }
            }
        });
        if (this.foundBzrPath == null) {
            restoreExistingDirButton.setEnabled(false);
        }
        this.setControl((Control)mainControl);
        this.setPageComplete(true);
    }

    public BazaarConfigurationWizard getWizard() {
        return (BazaarConfigurationWizard)super.getWizard();
    }

    public boolean isExistingBranch() {
        return this.foundBzrPath != null && this.foundBzrPath.equals((Object)this.bzrPath);
    }

    public IPath getPath() {
        return this.bzrPath;
    }

    public void setPath(Path path) {
        this.bzrPath = path;
    }

    public void setDefaultPath() {
        this.bzrPath = this.bzrPathOriginal;
    }
}

