/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.createproject;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class CreateProjectEntry
implements Listener {
    Scrollable textWidget;
    WizardPage page;
    boolean touched = false;
    CreateProjectEntry cascadeTo = null;
    String baseValue = "";
    protected Text text;

    public CreateProjectEntry(Composite parent, WizardPage page, String labelText, int width, String baseValue) {
        this.page = page;
        if (baseValue != null) {
            this.baseValue = baseValue;
        }
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        this.textWidget = this.createWidget(parent);
        GridData gridData = new GridData(512);
        gridData.horizontalAlignment = width == -1 ? 4 : 1;
        gridData.grabExcessHorizontalSpace = width == -1;
        gridData.widthHint = width;
        this.textWidget.setLayoutData((Object)gridData);
        this.textWidget.addListener(24, (Listener)this);
    }

    protected Scrollable createWidget(Composite parent) {
        this.text = new Text(parent, 2052);
        this.text.setText(this.baseValue);
        return this.text;
    }

    public void handleEvent(Event event) {
        block4: {
            if (this.textWidget.isFocusControl()) {
                this.touched = this.isModified();
                this.page.setMessage(null);
            }
            if (this.cascadeTo != null) {
                this.cascadeTo.cascade(this.getValue());
            }
            try {
                this.isValid();
                this.page.setPageComplete(true);
            }
            catch (BazaarException be) {
                this.page.setPageComplete(false);
                String message = be.getStatus().getMessage();
                if (message == null || message.length() <= 0) break block4;
                this.page.setMessage(message, 2);
            }
        }
    }

    public void setCascadeTo(CreateProjectEntry cascadeTo) {
        this.cascadeTo = cascadeTo;
    }

    private void cascade(String cascadeText) {
        String[] parts;
        if (this.touched) {
            return;
        }
        if ((cascadeText = cascadeText.trim()).startsWith("lp:")) {
            cascadeText = cascadeText.substring(3);
        }
        if ((parts = cascadeText.split("[\\\\/]")).length > 0) {
            cascadeText = parts[parts.length - 1];
        }
        this.setValue(String.valueOf(this.baseValue) + cascadeText);
        if (this.cascadeTo != null) {
            this.cascadeTo.cascade(this.getValue());
        }
    }

    public boolean isModified() {
        return this.getValue().length() > 0 && !this.getValue().equals(this.baseValue);
    }

    public void isValid() throws BazaarException {
        if (!this.isModified()) {
            throw new BazaarException("");
        }
    }

    public String getValue() {
        return this.text.getText();
    }

    public void setValue(String newValue) {
        this.text.setText(newValue);
    }
}

