/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.createproject;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.branch.BranchLocationManager;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.CreateProjectEntry;

public class CreateProjectRemoteBranch
extends CreateProjectEntry {
    protected Combo combo;
    private static String labelText = "Repository Location\nProvide a URL to a remote repository and branch, or browse for a branch on the local machine";

    public CreateProjectRemoteBranch(Composite parent, WizardPage page, int width, String baseValue) {
        super(parent, page, labelText, width, baseValue);
    }

    protected Scrollable createWidget(Composite parent) {
        Composite compo = new Composite(parent, 0);
        compo.setLayout((Layout)new GridLayout(2, false));
        this.combo = new Combo(compo, 2052);
        for (IBzrBranch br : BranchLocationManager.getAllBranches()) {
            this.combo.add(br.getBranchLocation().toString());
        }
        Button browse = new Button(compo, 8);
        browse.setText("Browse for folder");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(CreateProjectRemoteBranch.this.page.getShell());
                dialog.setMessage("Select folder");
                String seldir = dialog.open();
                if (seldir != null) {
                    CreateProjectRemoteBranch.this.combo.setText(seldir);
                }
            }
        });
        return this.combo;
    }

    public void isValid() throws BazaarException {
        super.isValid();
        try {
            new BranchLocation(this.getValue());
        }
        catch (BazaarClientException e) {
            throw new BazaarException(e.getMessage());
        }
    }

    public String getValue() {
        return this.combo.getText();
    }

    public void setValue(String newValue) {
        this.combo.setText(newValue);
    }
}

