/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.createproject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.operations.CheckoutBazaarProjectOperation;
import org.vcs.bazaar.eclipse.ui.operations.CreateBazaarProjectOperation;
import org.vcs.bazaar.eclipse.ui.team.BazaarUtilities;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.CreateProjectAdvancedPage;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.CreateProjectPage;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.ProjectWizardType;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.SelectProjectWizardWizard;

public class CreateProjectWizard
extends Wizard
implements INewWizard {
    private CreateProjectPage cpPage;
    private CreateProjectAdvancedPage cpaPage;
    protected String initialBranch = null;

    public CreateProjectWizard() {
        this.setWindowTitle(UITexts.CreateProjectWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public CreateProjectWizard(IStructuredSelection ss) {
        this();
        this.init(null, null);
        if (ss == null || ss.size() < 0) {
            throw new RuntimeException("Selection required");
        }
        if (ss.size() > 1) {
            throw new RuntimeException("Single Selection only supported");
        }
        if (!(ss.getFirstElement() instanceof IProject)) {
            throw new RuntimeException("Selection must be a Project");
        }
        IProject project = (IProject)ss.getFirstElement();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBzrWorkspaceRootFor((IProject)project).getBranch();
        this.initialBranch = branch.getBranchLocation().toString();
    }

    String getInitialBranch() {
        return this.initialBranch;
    }

    public void show(Shell shell) {
        new WizardDialog(shell, (IWizard)this).open();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (!EclipseBazaarCore.getDefault().isClientAvailable()) {
            BazaarUtilities.configureExecutable();
        }
    }

    public void addPages() {
        this.cpPage = new CreateProjectPage("BazaarCreateProjectPage", this);
        this.cpaPage = new CreateProjectAdvancedPage("BazaarCreateProjectPage", this);
        this.addPage((IWizardPage)this.cpPage);
        this.addPage((IWizardPage)this.cpaPage);
    }

    protected void setErrorMessage(Throwable e) {
        String message = "";
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof BazaarException) {
            message = ((BazaarException)e).getStatus().getMessage();
        } else if (e instanceof CoreException) {
            if (((CoreException)e).getStatus() != null) {
                message = ((CoreException)e).getStatus().getMessage();
                IStatus[] iStatusArray = ((CoreException)e).getStatus().getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus i = iStatusArray[n2];
                    message = String.valueOf(message) + i.getMessage();
                    ++n2;
                }
            } else {
                message = e.getMessage();
            }
        }
        EclipseBazaarUI.log(e);
        this.cpPage.setErrorMessage(message);
        this.cpaPage.setErrorMessage(message);
    }

    public IBzrBranch getRemoteBranch() throws BazaarException {
        return BranchFactory.findOrCreateFor((String)this.cpPage.getRepoLocation());
    }

    public boolean performFinish() {
        try {
            CheckoutBazaarProjectOperation cbpo = new CheckoutBazaarProjectOperation((IRunnableContext)this.getContainer(), this.getRemoteBranch(), this.cpPage.getBranchType(), this.cpaPage.getRevision());
            cbpo.run();
            File tempFolder = new File(cbpo.getProjectLocation());
            List projects = ResourceUtil.findProjects((File)tempFolder);
            SelectProjectWizardWizard wizard = new SelectProjectWizardWizard(!projects.isEmpty());
            wizard.show(this.getShell());
            CreateBazaarProjectOperation op = null;
            if (!wizard.isCancelled()) {
                if (wizard.getWizardType() == ProjectWizardType.WIZARD) {
                    List<IProject> previousProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
                    new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
                    IProject[] currentProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    IProject projectToUse = null;
                    IProject[] iProjectArray = currentProjects;
                    int n = currentProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject p = iProjectArray[n2];
                        if (!previousProjects.contains(p)) {
                            projectToUse = p;
                            break;
                        }
                        ++n2;
                    }
                    if (projectToUse != null) {
                        op = new CreateBazaarProjectOperation((IRunnableContext)this.getContainer(), tempFolder, projectToUse);
                        op.run();
                    }
                } else {
                    op = new CreateBazaarProjectOperation((IRunnableContext)this.getContainer(), tempFolder, wizard.getProjectName(), wizard.getProjectLocation(), wizard.getWizardType() == ProjectWizardType.IMPORT_EXISTING);
                    op.run();
                }
            }
            if (op == null) {
                ResourceUtil.deleteRecursively((File)tempFolder);
            }
            return true;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e);
        }
        catch (InterruptedException e) {
            this.setErrorMessage(e);
        }
        catch (BazaarException e) {
            this.setErrorMessage(e);
        }
        catch (IOException e) {
            this.setErrorMessage(e);
        }
        return false;
    }
}

