/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.createproject;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.wizards.BzrWizardPage;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.ProjectWizardType;

public class SelectProjectWizardPage
extends BzrWizardPage {
    private Button importExistingButton;
    private Button generalProjectButton;
    private Button newProjectWizardButton;
    private final boolean existing;

    public SelectProjectWizardPage(String pageName, boolean existing) {
        super(pageName, UITexts.CreateProjectPage_title);
        this.setDescription(UITexts.SelectProjectWizardPage_description);
        this.existing = existing;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite, 0);
        group.setText(UITexts.SelectProjectWizardType_groupTitle);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectWizardPage.this.setPageComplete(true);
            }
        };
        if (this.existing) {
            this.importExistingButton = new Button((Composite)group, 16);
            this.importExistingButton.setText(UITexts.SelectProjectWizardType_importExistingProjects);
            this.importExistingButton.setSelection(true);
            this.importExistingButton.addSelectionListener((SelectionListener)sl);
        }
        this.newProjectWizardButton = new Button((Composite)group, 16);
        this.newProjectWizardButton.setText(UITexts.SelectProjectWizardType_useNewProjestWizard);
        this.newProjectWizardButton.setSelection(!this.existing);
        this.newProjectWizardButton.addSelectionListener((SelectionListener)sl);
        this.generalProjectButton = new Button((Composite)group, 16);
        this.generalProjectButton.setText(UITexts.SelectProjectWizardType_importAsGeneralProject);
        this.generalProjectButton.setSelection(false);
        this.generalProjectButton.addSelectionListener((SelectionListener)sl);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public ProjectWizardType getWizardType() {
        if (this.generalProjectButton.getSelection()) {
            return ProjectWizardType.GENERAL;
        }
        if (this.newProjectWizardButton.getSelection()) {
            return ProjectWizardType.WIZARD;
        }
        return ProjectWizardType.IMPORT_EXISTING;
    }
}

