/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.createproject;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.ProjectWizardType;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.SelectProjectNamePage;
import org.vcs.bazaar.eclipse.ui.wizards.createproject.SelectProjectWizardPage;

public class SelectProjectWizardWizard
extends Wizard {
    private SelectProjectWizardPage selectWizardPage;
    private SelectProjectNamePage selectProjectNamePage;
    private ProjectWizardType wizardType;
    private String projectName;
    private String projectLocation;
    private boolean cancelled;
    private final boolean existing;

    public SelectProjectWizardWizard(boolean existing) {
        this.existing = existing;
        this.setWindowTitle(UITexts.CreateProjectWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.selectWizardPage = new SelectProjectWizardPage("SelectProjectWizardPage", this.existing);
        this.selectProjectNamePage = new SelectProjectNamePage("SelectProjectNamePage");
        this.addPage((IWizardPage)this.selectWizardPage);
        this.addPage((IWizardPage)this.selectProjectNamePage);
    }

    public boolean performFinish() {
        this.wizardType = this.selectWizardPage.getWizardType();
        this.projectName = this.selectProjectNamePage.getProjectName();
        this.projectLocation = this.selectProjectNamePage.getProjectLocation();
        this.cancelled = false;
        return true;
    }

    public boolean performCancel() {
        this.cancelled = true;
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectWizardPage) {
            switch (this.selectWizardPage.getWizardType()) {
                case IMPORT_EXISTING: 
                case GENERAL: {
                    return this.selectProjectNamePage;
                }
                case WIZARD: {
                    return null;
                }
            }
            return super.getNextPage(page);
        }
        return null;
    }

    public boolean canFinish() {
        switch (this.selectWizardPage.getWizardType()) {
            case IMPORT_EXISTING: 
            case GENERAL: {
                return this.selectProjectNamePage.isPageComplete();
            }
            case WIZARD: {
                return true;
            }
        }
        return super.canFinish();
    }

    public void show(Shell shell) {
        new WizardDialog(shell, (IWizard)this).open();
    }

    public ProjectWizardType getWizardType() {
        return this.wizardType;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }
}

