/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.patch;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePatchPage
extends WizardPage {
    private static final String PATH_KEY = "BazaarCreatePatchWizard.CreatePatchPage.path";
    private static final String LOCATION_KEY = "BazaarCreatePatchWizard.CreatePatchPage.location";
    private static final String LOCATION_VALUE_CLIPBOARD = "clipboard";
    private static final String LOCATION_VALUE_FILE_SYSTEM = "filesystem";
    private Button clipboardRadio;
    private Button fileRadio;
    private Text filePath;
    private Button fileBrowse;
    private BzrResourceSelectionComposite resourceSelection;
    private boolean pageValid;
    private IProject project;

    protected CreatePatchPage(String pageName, String title, ImageDescriptor titleImage, List<IBzrResourceStatus> resources, List<IBzrResourceStatus> selectedResources) {
        super(pageName, title, titleImage);
        this.project = resources.get(0).getResource().getIResource().getProject();
        this.resourceSelection = new BzrResourceSelectionComposite(true, true);
        this.resourceSelection.setResources(resources);
        this.resourceSelection.setSelection(selectedResources);
    }

    public void createControl(Composite parent) {
        boolean clipboardSelected;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.initializeDialogUnits((Control)composite);
        String selectedOption = this.getDialogSettings().get(LOCATION_KEY);
        if (selectedOption == null) {
            selectedOption = LOCATION_VALUE_CLIPBOARD;
        }
        boolean fileSelected = !(clipboardSelected = selectedOption.equals(LOCATION_VALUE_CLIPBOARD));
        GridData gd = new GridData(1, 1, false, false);
        gd.horizontalSpan = 3;
        this.clipboardRadio = new Button(composite, 16);
        this.clipboardRadio.setText(UITexts.CreatePatchWizard_Clipboard);
        this.clipboardRadio.setLayoutData((Object)gd);
        this.clipboardRadio.setSelection(clipboardSelected);
        this.fileRadio = new Button(composite, 16);
        this.fileRadio.setText(UITexts.CreatePatchWizard_File);
        this.fileRadio.setSelection(fileSelected);
        this.filePath = new Text(composite, 2048);
        gd = new GridData(768);
        this.filePath.setLayoutData((Object)gd);
        this.filePath.setText(this.createFileName());
        this.filePath.setEnabled(fileSelected);
        this.fileBrowse = new Button(composite, 8);
        this.fileBrowse.setText(UITexts.CreatePatchWizard_Browse);
        Composite control = this.resourceSelection.createControls(container);
        control.setLayoutData((Object)new GridData(1808));
        this.resourceSelection.addUntrackedFilesFilterIfNoUntrackedSelected();
        this.resourceSelection.refreshTableViewer();
        this.clipboardRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    CreatePatchPage.this.filePath.setEnabled(false);
                    CreatePatchPage.this.fileBrowse.setEnabled(false);
                    CreatePatchPage.this.getDialogSettings().put(CreatePatchPage.LOCATION_KEY, CreatePatchPage.LOCATION_VALUE_CLIPBOARD);
                    CreatePatchPage.this.validatePage();
                }
            }
        });
        this.fileRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    CreatePatchPage.this.filePath.setEnabled(true);
                    CreatePatchPage.this.fileBrowse.setEnabled(true);
                    CreatePatchPage.this.filePath.setFocus();
                    CreatePatchPage.this.getDialogSettings().put(CreatePatchPage.LOCATION_KEY, CreatePatchPage.LOCATION_VALUE_FILE_SYSTEM);
                    CreatePatchPage.this.validatePage();
                }
            }
        });
        this.filePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CreatePatchPage.this.validatePage()) {
                    IPath path = Path.fromOSString((String)CreatePatchPage.this.filePath.getText()).removeLastSegments(1);
                    CreatePatchPage.this.getDialogSettings().put(CreatePatchPage.PATH_KEY, path.toPortableString());
                }
            }
        });
        this.fileBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(CreatePatchPage.this.getShell(), 40960);
                if (CreatePatchPage.this.pageValid) {
                    File file = new File(CreatePatchPage.this.filePath.getText());
                    dialog.setFilterPath(file.getParent());
                    dialog.setFileName(file.getName());
                } else {
                    dialog.setFileName("");
                }
                dialog.setText("");
                String path = dialog.open();
                if (path != null) {
                    CreatePatchPage.this.filePath.setText(new Path(path).toOSString());
                }
                CreatePatchPage.this.validatePage();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)container);
        this.validatePage();
    }

    private boolean validatePage() {
        this.pageValid = this.fileRadio.getSelection() ? this.validateFile() : true;
        if (this.pageValid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setPageComplete(this.pageValid);
        return this.pageValid;
    }

    private boolean validateFile() {
        String pathString = this.filePath.getText().trim();
        if (pathString.length() == 0 || !new Path("").isValidPath(pathString)) {
            this.setErrorMessage(UITexts.CreatePatchWizard_FilesystemInvalid);
            return false;
        }
        File file = new File(pathString);
        if (!file.isAbsolute()) {
            this.setErrorMessage(UITexts.CreatePatchWizard_FilesystemInvalid);
            return false;
        }
        if (file.isDirectory()) {
            this.setErrorMessage(UITexts.CreatePatchWizard_FilesystemInvalid);
            return false;
        }
        if (pathString.endsWith("/") || pathString.endsWith("\\")) {
            this.setErrorMessage(UITexts.CreatePatchWizard_FilesystemInvalid);
            return false;
        }
        File parent = file.getParentFile();
        if (!parent.exists() || !parent.isDirectory()) {
            this.setErrorMessage(UITexts.CreatePatchWizard_FilesystemInvalid);
            return false;
        }
        if (file.exists() && !file.canWrite()) {
            this.setErrorMessage(UITexts.CreatePatchWizard_FilesystemReadOnly);
            return false;
        }
        return true;
    }

    private String createFileName() {
        String suggestedFileName = this.project.getName().concat(".patch");
        String path = this.getDialogSettings().get(PATH_KEY);
        if (path != null) {
            return Path.fromPortableString((String)path).append(suggestedFileName).toOSString();
        }
        return new File(System.getProperty("user.dir", ""), suggestedFileName).getPath();
    }

    public File getFile() {
        if (this.pageValid && this.fileRadio.getSelection()) {
            return new File(this.filePath.getText().trim());
        }
        return null;
    }

    public List<IBzrResourceStatus> getSelectedResources() {
        return this.resourceSelection.getSelection();
    }
}

