/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.wizards.patch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UIIcons;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.operations.CreatePatchOperation;
import org.vcs.bazaar.eclipse.ui.wizards.patch.CreatePatchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePatchWizard
extends Wizard {
    private CreatePatchPage page;
    private List<IBzrResourceStatus> resources;
    private List<IBzrResourceStatus> selectedResources;
    private static final String DIALOG_SETTINGS_SECTION = "CreatePatchWizard";

    public CreatePatchWizard(List<IBzrResourceStatus> resources, List<IBzrResourceStatus> selectedResources) {
        this.resources = resources;
        this.selectedResources = selectedResources;
        this.setWindowTitle(UITexts.CreatePatchWizard_WindowTitle);
        IDialogSettings section = EclipseBazaarUI.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = EclipseBazaarUI.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_SECTION);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        String pageTitle = UITexts.CreatePatchWizard_Title;
        String pageDescription = UITexts.CreatePatchWizard_Description;
        this.page = new CreatePatchPage(pageTitle, pageTitle, UIIcons.WIZBAN_CREATE_PATCH, this.resources, this.selectedResources);
        this.page.setDescription(pageDescription);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final File file = this.page.getFile();
        if (file != null && !this.validateFile(file)) {
            return false;
        }
        final CreatePatchOperation operation = new CreatePatchOperation((IRunnableContext)this.getContainer(), this.page.getSelectedResources(), null, null);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        operation.run(monitor);
                        String content = operation.getPatchContent();
                        if (file != null) {
                            CreatePatchWizard.this.writeToFile(file, content);
                            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
                            int i = 0;
                            while (i < files.length) {
                                files[i].refreshLocal(0, monitor);
                                ++i;
                            }
                        } else {
                            CreatePatchWizard.this.copyToClipboard(content);
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(e.getMessage() == null ? e.getMessage() : UITexts.CreatePatchWizard_InternalError);
        }
        return true;
    }

    private void copyToClipboard(final String content) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(CreatePatchWizard.this.getShell().getDisplay());
                clipboard.setContents((Object[])new String[]{content}, new Transfer[]{plainTextTransfer});
                clipboard.dispose();
            }
        });
    }

    private boolean validateFile(File file) {
        if (file.exists()) {
            MessageDialog dialog = new MessageDialog(this.getShell(), UITexts.CreatePatchWizard_OverwriteTitle, null, UITexts.CreatePatchWizard_OverwriteMsg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return false;
            }
        }
        return true;
    }

    private void writeToFile(File file, String content) throws IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        try {
            output.write(content);
        }
        finally {
            ((Writer)output).close();
        }
    }
}

